(* ::Package:: *)

(* ::Title:: *)
(*A. F. Timofeev - Integration of Functions (1948)*)


(* ::Section::Closed:: *)
(*Chapter 1 Integration Problems*)


(* ::Subsection::Closed:: *)
(*Problems 1 - 5 (p. 25)*)


{1/(a^2 - b^2*x^2), x, 1, ArcTanh[(b*x)/a]/(a*b)}
{1/(a^2 + b^2*x^2), x, 1, ArcTan[(b*x)/a]/(a*b)}
{Sec[2*a*x], x, 1, ArcTanh[Sin[2*a*x]]/(2*a)}
{1/(4*Sin[x/3]), x, 2, (-3*ArcTanh[Cos[x/3]])/4}
{1/Cos[3*Pi/4 - 2*x], x, 1, -ArcTanh[Sin[Pi/4 + 2*x]]/2}


(* ::Subsection::Closed:: *)
(*Problems 6 - 11 (p. 25-26)*)


{Sec[x]*Tan[x], x, 2, Sec[x]}
{Csc[x]*Cot[x], x, 2, -Csc[x]}
{Tan[x]/Sin[2*x], x, 2, Tan[x]/2}
{1/(1 + Cos[x]), x, 1, Sin[x]/(1 + Cos[x])}
{1/(1 - Cos[x]), x, 1, -(Sin[x]/(1 - Cos[x]))}
{Sin[x]/(a - b*Cos[x]), x, 2, Log[a - b*Cos[x]]/b}


(* ::Subsection::Closed:: *)
(*Problems 12 - 16 (p. 26)*)


{Cos[x]/(a^2 + b^2*Sin[x]^2), x, 2, ArcTan[(b*Sin[x])/a]/(a*b)}
{Cos[x]/(a^2 - b^2*Sin[x]^2), x, 2, ArcTanh[(b*Sin[x])/a]/(a*b)}
{Sin[2*x]/(a^2 + b^2*Sin[x]^2), x, 3, Log[a^2 + b^2*Sin[x]^2]/b^2}
{Sin[2*x]/(a^2 - b^2*Sin[x]^2), x, 3, -Log[a^2 - b^2*Sin[x]^2]/b^2}
{Sin[2*x]/(a^2 + b^2*Cos[x]^2), x, 3, -Log[a^2 + b^2*Cos[x]^2]/b^2, -Log[a^2 + b^2 - b^2*Sin[x]^2]/b^2}
{Sin[2*x]/(a^2 - b^2*Cos[x]^2), x, 3, Log[a^2 - b^2*Cos[x]^2]/b^2, Log[a^2 - b^2 + b^2*Sin[x]^2]/b^2}
{1/(4 - Cos[x]^2), x, 2, x/(2*Sqrt[3]) + (1/(2*Sqrt[3]))*ArcTan[(Cos[x]*Sin[x])/(3 + 2*Sqrt[3] + Sin[x]^2)]}


(* ::Subsection::Closed:: *)
(*Problems 17 - 21 (p. 26)*)


{E^x/(-1 + E^(2*x)), x, 2, -ArcTanh[E^x]}
{1/(x*Log[x]), x, 2, Log[Log[x]]}
{1/(x*(1 + Log[x]^2)), x, 2, ArcTan[Log[x]]}
{1/(x*(1 - Log[x])), x, 2, -Log[1 - Log[x]]}
{1/(x*(1 + Log[x/a])), x, 2, Log[1 + Log[x/a]]}


(* ::Subsection::Closed:: *)
(*Problems 22 - 26 (p. 27)*)


{(1 - Sqrt[x] + x)^2/x^2, x, 3, -1/x + 4/Sqrt[x] - 4*Sqrt[x] + x + 3*Log[x]}
{(2 - x^(2/3))*(x + Sqrt[x])/x^(3/2), x, 4, 4*Sqrt[x] - (3*x^(2/3))/2 - (6*x^(7/6))/7 + 2*Log[x]}
{(2*x - 1)/(2*x + 3), x, 2, x - 2*Log[2*x + 3]}
{(2*x - 5)/(3*x^2 - 2), x, 3, (1/12)*(4 - 5*Sqrt[6])*Log[Sqrt[6] - 3*x] + (1/12)*(4 + 5*Sqrt[6])*Log[Sqrt[6] + 3*x]}
{(2*x - 5)/(3*x^2 + 2), x, 3, (-5*ArcTan[Sqrt[3/2]*x])/Sqrt[6] + Log[3*x^2 + 2]/3}


(* ::Subsection::Closed:: *)
(*Problems 27 - 33 (p. 27-28)*)


{Sin[x/4]*Sin[x], x, 1, (2*Sin[(3*x)/4])/3 - (2*Sin[(5*x)/4])/5}
{Cos[3*x]*Cos[4*x], x, 1, Sin[x]/2 + Sin[7*x]/14}
{Tan[x]*Tan[x - a], x, 4, -x + Cot[a]*Log[Cos[x - a]] - Cot[a]*Log[Cos[x]]}
{Sin[x]^2, x, 2, x/2 - (Cos[x]*Sin[x])/2}
{Cos[x]^2, x, 2, x/2 + (Cos[x]*Sin[x])/2}
{Sin[x]*Cos[x]^3, x, 2, -Cos[x]^4/4}
{Cos[x]^3/Sin[x]^4, x, 2, 1/Sin[x] - 1/(3*Sin[x]^3)}
{1/(Sin[x]^2*Cos[x]^2), x, 3, Tan[x] - Cot[x]}


(* ::Subsection::Closed:: *)
(*Problems 34 - 37 (p. 28)*)


{Cot[3*x/4]^2, x, 2, -x - (4*Cot[(3*x)/4])/3}
{(1 + Tan[2*x])^2, x, 2, -Log[Cos[2*x]] + Tan[2*x]/2}
{(Tan[x] - Cot[x])^2, x, 4, -4*x - Cot[x] + Tan[x]}
{(Tan[x] - Sec[x])^2, x, 4, -x - (2*Cos[x])/(1 + Sin[x])}


(* ::Subsection::Closed:: *)
(*Problems 38 - 40 (p. 28)*)


{Sin[x]/(1 + Sin[x]), x, 2, x + Cos[x]/(1 + Sin[x])}
{Cos[x]/(1 - Cos[x]), x, 2, -x - Sin[x]/(1 - Cos[x])}
{(E^(x/2) - 1)^3*E^(-x/2), x, 3, 2/E^(x/2) - 6*E^(x/2) + E^x + 3*x}


(* ::Subsection::Closed:: *)
(*Problems 41 - 43 (p. 35)*)


{1/(5 - 6*x + x^2), x, 3, -Log[1 - x]/4 + Log[5 - x]/4}
{x^2/(13 - 6*x^3 + x^6), x, 3, (1/6)*ArcTan[(1/2)*(-3 + x^3)]}
{(2 + x)/(-1 - 4*x + x^2), x, 3, ((5 - 4*Sqrt[5])*Log[2 - Sqrt[5] - x])/10 + ((5 + 4*Sqrt[5])*Log[2 + Sqrt[5] - x])/10}


(* ::Subsection::Closed:: *)
(*Problems 44 - 48c (p. 35-36)*)


{1/(1 + (1 + x)^(1/3)), x, 4, -3*(1 + x)^(1/3) + (3*(1 + x)^(2/3))/2 + 3*Log[1 + (1 + x)^(1/3)]}
{1/(Sqrt[x]*(a*x + b)), x, 2, (2*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/(Sqrt[a]*Sqrt[b])}
{x^3*Sqrt[1 + x^2], x, 3, -(1 + x^2)^(3/2)/3 + (1 + x^2)^(5/2)/5}
{x/Sqrt[a^4 - x^4], x, 3, ArcTan[x^2/Sqrt[a^4 - x^4]]/2}
{1/(x*Sqrt[x^2 - a^2]), x, 3, ArcTan[Sqrt[x^2 - a^2]/a]/a}
{1/(x*Sqrt[a^2 - x^2]), x, 3, -(ArcTanh[Sqrt[a^2 - x^2]/a]/a)}
{1/(x*Sqrt[x^2 + a^2]), x, 3, -(ArcTanh[Sqrt[x^2 + a^2]/a]/a)}


(* ::Subsection::Closed:: *)
(*Problems 49 - 54 (p. 36)*)


{1/Sqrt[2 + x - x^2], x, 2, -ArcSin[(1 - 2*x)/3]}
{1/Sqrt[5 - 4*x + 3*x^2], x, 2, -(ArcSinh[(2 - 3*x)/Sqrt[11]]/Sqrt[3])}
{1/Sqrt[x - x^2], x, 2, -ArcSin[1 - 2*x]}
{(1 + 2*x)/Sqrt[2 + x - x^2], x, 3, -2*Sqrt[2 + x - x^2] - 2*ArcSin[(1 - 2*x)/3]}
{1/(x*Sqrt[2 + x - x^2]), x, 2, -(ArcTanh[(4 + x)/(2*Sqrt[2]*Sqrt[2 + x - x^2])]/Sqrt[2])}
{1/((x - 2)*Sqrt[2 + x - x^2]), x, 1, 2*Sqrt[2 + x - x^2]/(3*(x - 2)), -((2*Sqrt[2 + x - x^2])/(3*(2 - x)))}


(* ::Subsection::Closed:: *)
(*Problems 55 - 60 (p. 36-37)*)


{(2 + 3*Sin[x])/(Sin[x]*(1 - Cos[x])), x, 7, -ArcTanh[Cos[x]] - 1/(1 - Cos[x]) - (3*Sin[x])/(1 - Cos[x])}
{1/(2 + 3*Cos[x]^2), x, 2, x/Sqrt[10] - 1/Sqrt[10]*ArcTan[3*Cos[x]*Sin[x]/(2 + Sqrt[10] + 3*Cos[x]^2)], x/Sqrt[10] - ArcTan[((-1 + Sqrt[5/2])*Cos[x]*Sin[x])/(1 + (-1 + Sqrt[5/2])*Cos[x]^2)]/Sqrt[10]}
{(1 - Tan[x])/Sin[2*x], x, 3, Log[Tan[x]]/2 - Tan[x]/2}
{(1 + Tan[x]^2)/(1 - Tan[x]^2), x, 2, (1/2)*ArcTanh[2*Cos[x]*Sin[x]]}
{(a^2 - 4*Cos[x]^2)^(3/4)*Sin[2*x], x, 3, (1/7)*(a^2 - 4*Cos[x]^2)^(7/4), 1/7*(a^2 - 4 + 4*Sin[x]^2)^(7/4)}
{Sin[2*x]/(a^2 - 4*Sin[x]^2)^(1/3), x, 3, -3/8*(a^2 - 4*Sin[x]^2)^(2/3)}


(* ::Subsection::Closed:: *)
(*Problems 61 - 65 (p. 37)*)


{1/Sqrt[a^(2*x) - 1], x, 3, ArcTan[Sqrt[a^(2*x) - 1]]/Log[a]}
{E^(x/2)/Sqrt[E^x - 1], x, 3, 2*ArcTanh[E^(x/2)/Sqrt[E^x - 1]]}
{ArcTan[x]^n/(1 + x^2), x, 1, ArcTan[x]^(n + 1)/(n + 1)}
{ArcSin[x/a]^(3/2)/Sqrt[a^2 - x^2], x, 1, (2*a*Sqrt[1 - x^2/a^2]*ArcSin[x/a]^(5/2))/(5*Sqrt[a^2 - x^2])}
{1/(ArcCos[x]^3*Sqrt[1 - x^2]), x, 1, 1/(2*ArcCos[x]^2)}


(* ::Subsection::Closed:: *)
(*Problems 66 - 68 (p. 41)*)


{x*Log[x]^2, x, 2, x^2/4 - (x^2*Log[x])/2 + (x^2*Log[x]^2)/2}
{Log[x]/x^5, x, 1, -1/(16*x^4) - Log[x]/(4*x^4)}
{x^2*Log[(x - 1)/x], x, 5, -x/3 - x^2/6 + x^3*Log[(x - 1)/x]/3 - Log[x - 1]/3, -(x/3) - x^2/6 + (1/3)*x^3*Log[1 - 1/x] - (1/3)*Log[1 - x]}


(* ::Subsection::Closed:: *)
(*Problems 69 - 71 (p. 41)*)


{Cos[x]^5, x, 2, Sin[x] - (2*Sin[x]^3)/3 + Sin[x]^5/5}
{Sin[x]^2*Cos[x]^4, x, 4, x/16 + (Cos[x]*Sin[x])/16 + (Cos[x]^3*Sin[x])/24 - (Cos[x]^5*Sin[x])/6}
{1/Sin[x]^5, x, 3, (-3*ArcTanh[Cos[x]])/8 - (3*Cot[x]*Csc[x])/8 - (Cot[x]*Csc[x]^3)/4}


(* ::Subsection::Closed:: *)
(*Problems 72 - 76 (p. 42)*)


{Sin[x]/E^x, x, 1, -Cos[x]/(2*E^x) - Sin[x]/(2*E^x)}
{E^(2*x)*Sin[3*x], x, 1, (-3*E^(2*x)*Cos[3*x])/13 + (2*E^(2*x)*Sin[3*x])/13}
{a^x*Cos[x], x, 1, (a^x*Cos[x]*Log[a])/(1 + Log[a]^2) + (a^x*Sin[x])/(1 + Log[a]^2)}
{Cos[Log[x]], x, 1, (x*Cos[Log[x]])/2 + (x*Sin[Log[x]])/2}
{Sec[x]^2*Log[Cos[x]], x, 3, -x + Tan[x] + Log[Cos[x]]*Tan[x]}


(* ::Subsection::Closed:: *)
(*Problems 77 - 81 (p. 42)*)


{x*Tan[x]^2, x, 3, -x^2/2 + Log[Cos[x]] + x*Tan[x]}
{ArcSin[x]/x^2, x, 4, -(ArcSin[x]/x) - ArcTanh[Sqrt[1 - x^2]]}
{ArcSin[x]^2, x, 3, -2*x + 2*Sqrt[1 - x^2]*ArcSin[x] + x*ArcSin[x]^2}
{ArcTan[x]*x^2/(1 + x^2), x, 4, x*ArcTan[x] - ArcTan[x]^2/2 - Log[1 + x^2]/2}
{ArcCos[Sqrt[x/(1 + x)]], x, 6, (1 + x)*(Sqrt[1/(1 + x)]*Sqrt[x/(1 + x)] + ArcCos[Sqrt[x/(1 + x)]]), Sqrt[x/(1 + x)^2]*(1 + x) + x*ArcCos[Sqrt[x/(1 + x)]] - (Sqrt[x/(1 + x)^2]*(1 + x)*ArcTan[Sqrt[x]])/Sqrt[x]}


(* ::Section::Closed:: *)
(*Chapter 2 Integration Problems*)


(* ::Subsection::Closed:: *)
(*Problems 1 - 3 (p. 60)*)


{(3*x^2 + 2*x)^3, x, 2, 2*x^4 + (36*x^5)/5 + 9*x^6 + (27*x^7)/7}
{(3*x^2 + 2*x - 1)^2*(x - 1), x, 2, -x + (5*x^2)/2 - (2*x^3)/3 - (7*x^4)/2 + (3*x^5)/5 + (3*x^6)/2}
{(a + b*x^k)^n*x^(k - 1), x, 1, (a + b*x^k)^(1 + n)/(b*k*(1 + n))}


(* ::Subsection::Closed:: *)
(*Problems 4 - 9 (p. 62-63)*)


{x^3/(1 + 2*x), x, 2, x/8 - x^2/8 + x^3/6 - (1/16)*Log[1 + 2*x]}
{x^6/(2 + 3*x^2), x, 3, (4*x)/27 - (2*x^3)/27 + x^5/15 - (4/27)*Sqrt[2/3]*ArcTan[Sqrt[3/2]*x]}
{1/(3*x^2 - 7*x + 2), x, 3, (-(1/5))*Log[1 - 3*x] + (1/5)*Log[2 - x]}
{(3*x - 1)/(x^2 - x + 1), x, 4, -(ArcTan[(1 - 2*x)/Sqrt[3]]/Sqrt[3]) + (3/2)*Log[1 - x + x^2]}
{x^2/(5 + 2*x + x^2), x, 5, x - (3/2)*ArcTan[(1 + x)/2] - Log[5 + 2*x + x^2]}
{(6*x^4 - 5*x^3 + 4*x^2)/(2*x^2 - x + 1), x, 7, -(x^2/2) + x^3 - ArcTan[(1 - 4*x)/Sqrt[7]]/(2*Sqrt[7]) + (1/4)*Log[1 - x + 2*x^2]}


(* ::Subsection::Closed:: *)
(*Problems 10 - 14 (p. 63)*)


{(x^2 + x - 1)/(x^3 + x^2 - 6*x), x, 3, (1/2)*Log[2 - x] + Log[x]/6 + (1/3)*Log[3 + x]}
{(5*x^2 - 7*a*x + 11*a^2)/(x^3 - 6*a x^2 + 11*a^2*x - 6*a^3), x, 2, (9/2)*Log[a - x] - 17*Log[2*a - x] + (35/2)*Log[3*a - x]}
{(x^2 - x + 2)/(x^4 - 5*x^2 + 4), x, 12, (-(1/3))*Log[1 - x] + (1/3)*Log[2 - x] + (2/3)*Log[1 + x] - (2/3)*Log[2 + x], (-(1/2))*Log[1 - x] + (1/2)*Log[2 - x] + (1/2)*Log[1 + x] - (1/2)*Log[2 + x] + (1/6)*Log[1 - x^2] - (1/6)*Log[4 - x^2]}
{(2*x^2 - 5)/(x^4 - 5*x^2 + 6), x, 3, -(ArcTanh[x/Sqrt[2]]/Sqrt[2]) - ArcTanh[x/Sqrt[3]]/Sqrt[3]}
{1/((x - 1)*(x - 2)*(x - 3)*(x - 4)), x, 2, (-(1/6))*Log[1 - x] + (1/2)*Log[2 - x] - (1/2)*Log[3 - x] + (1/6)*Log[4 - x]}


(* ::Subsection::Closed:: *)
(*Problems 15 - 17 (p. 64)*)


{(x^2 + 1)/(x - 1)^3, x, 2, -(1/(1 - x)^2) + 2/(1 - x) + Log[1 - x]}
{x^5/(3 + x)^2, x, 2, -108*x + (27*x^2)/2 - 2*x^3 + x^4/4 + 243/(3 + x) + 405*Log[3 + x]}
{(5*x^3 - 2)/(x^4 - 8*x^3 + 18*x^2 - 27), x, 2, -(133/(8*(3 - x)^2)) + 407/(16*(3 - x)) + (313/64)*Log[3 - x] + (7/64)*Log[1 + x]}


(* ::Subsection::Closed:: *)
(*Problems 18 - 20 (p. 65)*)


{(x^3 - 6*x^2 + 3*x - 9)/((x + 3)^2*(x + 4)^2), x, 2, 99/(3 + x) + 181/(4 + x) + 264*Log[3 + x] - 263*Log[4 + x]}
{(x^3 + x^2 + 2)/(x*(x^2 - 1)^2), x, 3, (3 + x)/(2*(1 - x^2)) - (3/4)*Log[1 - x] + 2*Log[x] - (5/4)*Log[1 + x]}
{1/(x^3 - x^4 - x^5 + x^6), x, 2, 1/(2*(1 - x)) - 1/(2*x^2) - 1/x - (7/4)*Log[1 - x] + 2*Log[x] - (1/4)*Log[1 + x]}


(* ::Subsection::Closed:: *)
(*Problems 21 - 25 (p. 66)*)


{(x^4 + 1)/(x^3 - x^2 + x - 1), x, 5, x + x^2/2 - ArcTan[x] + Log[1 - x] - (1/2)*Log[1 + x^2]}
{1/(x*(1 + x)*(1 + x^2)), x, 5, -(ArcTan[x]/2) + Log[x] - (1/2)*Log[1 + x] - (1/4)*Log[1 + x^2]}
{x^2/(x^4 + x^2 - 2), x, 3, (1/3)*Sqrt[2]*ArcTan[x/Sqrt[2]] - ArcTanh[x]/3}
{(x^3 + 4*x^2 + 6*x)/(x^4 + 2*x^3 + 3*x^2 + 4*x + 2), x, 6, 1/(1 + x) + (4/3)*Sqrt[2]*ArcTan[x/Sqrt[2]] - (1/3)*Log[1 + x] + (2/3)*Log[2 + x^2]}
{x/((1 + x)*(1 + 2*x)^2*(1 + x^2)), x, 5, 2/(5*(1 + 2*x)) + ArcTan[x]/50 - (1/2)*Log[1 + x] + (16/25)*Log[1 + 2*x] - (7/100)*Log[1 + x^2]}


(* ::Subsection::Closed:: *)
(*Problems 26 - 27 (p. 67)*)


{(3*x^2 + x - 2)/((x - 1)^3*(x^2 + 1)), x, 5, -(1/(2*(1 - x)^2)) + 5/(2*(1 - x)) - ArcTan[x] - (3/2)*Log[1 - x] + (3/4)*Log[1 + x^2]}
{1/(x^4 + x^2 + 1), x, 9, -(ArcTan[(1 - 2*x)/Sqrt[3]]/(2*Sqrt[3])) + ArcTan[(1 + 2*x)/Sqrt[3]]/(2*Sqrt[3]) - (1/4)*Log[1 - x + x^2] + (1/4)*Log[1 + x + x^2]}


(* ::Subsection::Closed:: *)
(*Problems 28 - 32 (p. 68)*)


{(2*x^3 + 3)/(x^5 - 9*x), x, 10, ArcTan[x/Sqrt[3]]/Sqrt[3] - ArcTanh[x/Sqrt[3]]/Sqrt[3] - Log[x]/3 + (1/12)*Log[9 - x^4]}
{(5*x^3 + 8*x - 20)/((x - 4)^3*(x^2 - 4*x + 8)), x, 6, -(83/(4*(4 - x)^2)) + 41/(4*(4 - x)) - (3/16)*ArcTan[1 - x/2] - (45/16)*Log[4 - x] + (45/32)*Log[8 - 4*x + x^2]}
{1/((x^2 + 1)*(x^2 + 2)*(x^2 + 3)*(x^2 + 4)), x, 6, (-(1/12))*ArcTan[x/2] + ArcTan[x]/6 - ArcTan[x/Sqrt[2]]/(2*Sqrt[2]) + ArcTan[x/Sqrt[3]]/(2*Sqrt[3])}
{x/((x^2 + 1)*(x^2 + 2)*(x^2 + 3)*(x^2 + 4)), x, 3, (1/12)*Log[1 + x^2] - (1/4)*Log[2 + x^2] + (1/4)*Log[3 + x^2] - (1/12)*Log[4 + x^2]}
{1/(a^3 + x^3), x, 6, -(ArcTan[(a - 2*x)/(Sqrt[3]*a)]/(Sqrt[3]*a^2)) + Log[a + x]/(3*a^2) - Log[a^2 - a*x + x^2]/(6*a^2)}


(* ::Subsection::Closed:: *)
(*Problems 33 - 44 (p. 69)*)


{x/(a^3 + x^3), x, 6, -(ArcTan[(a - 2*x)/(Sqrt[3]*a)]/(Sqrt[3]*a)) - Log[a + x]/(3*a) + Log[a^2 - a*x + x^2]/(6*a)}
{x^2/(a^3 + x^3), x, 1, (1/3)*Log[a^3 + x^3]}
{1/(x*(a^3 + x^3)), x, 4, Log[x]/a^3 - Log[a^3 + x^3]/(3*a^3)}
{1/(x^2*(a^3 + x^3)), x, 7, -(1/(a^3*x)) + ArcTan[(a - 2*x)/(Sqrt[3]*a)]/(Sqrt[3]*a^4) + Log[a + x]/(3*a^4) - Log[a^2 - a*x + x^2]/(6*a^4)}
{1/(x^3*(a^3 + x^3)), x, 7, -(1/(2*a^3*x^2)) + ArcTan[(a - 2*x)/(Sqrt[3]*a)]/(Sqrt[3]*a^5) - Log[a + x]/(3*a^5) + Log[a^2 - a*x + x^2]/(6*a^5)}
{1/(x^4*(a^3 + x^3)), x, 3, -(1/(3*a^3*x^3)) - Log[x]/a^6 + Log[a^3 + x^3]/(3*a^6)}
{1/(x^5*(a^3 + x^3)), x, 8, -(1/(4*a^3*x^4)) + 1/(a^6*x) - ArcTan[(a - 2*x)/(Sqrt[3]*a)]/(Sqrt[3]*a^7) - Log[a + x]/(3*a^7) + Log[a^2 - a*x + x^2]/(6*a^7)}
{1/(x^m*(a^3 + x^3)), x, 1, (x^(1 - m)*Hypergeometric2F1[1, (1 - m)/3, (4 - m)/3, -(x^3/a^3)])/(a^3*(1 - m))}
{1/(a^4 - x^4), x, 3, ArcTan[x/a]/(2*a^3) + ArcTanh[x/a]/(2*a^3)}
{x/(a^4 - x^4), x, 2, ArcTanh[x^2/a^2]/(2*a^2)}
{1/(x*(a^4 - x^4)), x, 4, Log[x]/a^4 - Log[a^4 - x^4]/(4*a^4)}
{1/(x^2*(a^4 - x^4)), x, 4, -(1/(a^4*x)) - ArcTan[x/a]/(2*a^5) + ArcTanh[x/a]/(2*a^5)}
{1/(x^3*(a^4 - x^4)), x, 3, -(1/(2*a^4*x^2)) + ArcTanh[x^2/a^2]/(2*a^6)}
{1/(x^4*(a^4 - x^4)), x, 4, -(1/(3*a^4*x^3)) + ArcTan[x/a]/(2*a^7) + ArcTanh[x/a]/(2*a^7)}
{1/(x^m*(a^4 - x^4)), x, 1, (x^(1 - m)*Hypergeometric2F1[1, (1 - m)/4, (5 - m)/4, x^4/a^4])/(a^4*(1 - m))}
{x/(a^4 + x^4), x, 2, ArcTan[x^2/a^2]/(2*a^2)}
{x^2/(a^4 + x^4), x, 9, -(ArcTan[1 - (Sqrt[2]*x)/a]/(2*Sqrt[2]*a)) + ArcTan[1 + (Sqrt[2]*x)/a]/(2*Sqrt[2]*a) + Log[a^2 - Sqrt[2]*a*x + x^2]/(4*Sqrt[2]*a) - Log[a^2 + Sqrt[2]*a*x + x^2]/(4*Sqrt[2]*a)}
{1/(a^5 + x^5), x, 6, -((Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[((1 - Sqrt[5])*a - 4*x)/(Sqrt[2*(5 + Sqrt[5])]*a)])/(5*a^4)) - (Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[(Sqrt[(1/10)*(5 + Sqrt[5])]*((1 + Sqrt[5])*a - 4*x))/(2*a)])/(5*a^4) + Log[a + x]/(5*a^4) - ((1 - Sqrt[5])*Log[a^2 - (1/2)*(1 - Sqrt[5])*a*x + x^2])/(20*a^4) - ((1 + Sqrt[5])*Log[a^2 - (1/2)*(1 + Sqrt[5])*a*x + x^2])/(20*a^4)}


(* ::Subsection::Closed:: *)
(*Problems 45 - 50 (p. 71-72)*)


{x/(a^5 + x^5), x, 6, (Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[((1 - Sqrt[5])*a - 4*x)/(Sqrt[2*(5 + Sqrt[5])]*a)])/(5*a^3) - (Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[(Sqrt[(1/10)*(5 + Sqrt[5])]*((1 + Sqrt[5])*a - 4*x))/(2*a)])/(5*a^3) - Log[a + x]/(5*a^3) + ((1 + Sqrt[5])*Log[a^2 - (1/2)*(1 - Sqrt[5])*a*x + x^2])/(20*a^3) + ((1 - Sqrt[5])*Log[a^2 - (1/2)*(1 + Sqrt[5])*a*x + x^2])/(20*a^3)}
{x^2/(a^5 + x^5), x, 6, (Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[((1 - Sqrt[5])*a - 4*x)/(Sqrt[2*(5 + Sqrt[5])]*a)])/(5*a^2) - (Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[(Sqrt[(1/10)*(5 + Sqrt[5])]*((1 + Sqrt[5])*a - 4*x))/(2*a)])/(5*a^2) + Log[a + x]/(5*a^2) - ((1 + Sqrt[5])*Log[a^2 - (1/2)*(1 - Sqrt[5])*a*x + x^2])/(20*a^2) - ((1 - Sqrt[5])*Log[a^2 - (1/2)*(1 + Sqrt[5])*a*x + x^2])/(20*a^2)}
{x^3/(a^5 + x^5), x, 6, -((Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[((1 - Sqrt[5])*a - 4*x)/(Sqrt[2*(5 + Sqrt[5])]*a)])/(5*a)) - (Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[(Sqrt[(1/10)*(5 + Sqrt[5])]*((1 + Sqrt[5])*a - 4*x))/(2*a)])/(5*a) - Log[a + x]/(5*a) + ((1 - Sqrt[5])*Log[a^2 - (1/2)*(1 - Sqrt[5])*a*x + x^2])/(20*a) + ((1 + Sqrt[5])*Log[a^2 - (1/2)*(1 + Sqrt[5])*a*x + x^2])/(20*a)}
{x^4/(a^5 + x^5), x, 1, (1/5)*Log[a^5 + x^5]}
{1/(x*(a^5 + x^5)), x, 4, Log[x]/a^5 - Log[a^5 + x^5]/(5*a^5)}
{1/(x^2*(a^5 + x^5)), x, 7, -(1/(a^5*x)) + (Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[((1 - Sqrt[5])*a - 4*x)/(Sqrt[2*(5 + Sqrt[5])]*a)])/(5*a^6) + (Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[(Sqrt[(1/10)*(5 + Sqrt[5])]*((1 + Sqrt[5])*a - 4*x))/(2*a)])/(5*a^6) + Log[a + x]/(5*a^6) - ((1 - Sqrt[5])*Log[a^2 - (1/2)*(1 - Sqrt[5])*a*x + x^2])/(20*a^6) - ((1 + Sqrt[5])*Log[a^2 - (1/2)*(1 + Sqrt[5])*a*x + x^2])/(20*a^6)}
{1/(x^3*(a^5 + x^5)), x, 7, -(1/(2*a^5*x^2)) - (Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[((1 - Sqrt[5])*a - 4*x)/(Sqrt[2*(5 + Sqrt[5])]*a)])/(5*a^7) + (Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[(Sqrt[(1/10)*(5 + Sqrt[5])]*((1 + Sqrt[5])*a - 4*x))/(2*a)])/(5*a^7) - Log[a + x]/(5*a^7) + ((1 + Sqrt[5])*Log[a^2 - (1/2)*(1 - Sqrt[5])*a*x + x^2])/(20*a^7) + ((1 - Sqrt[5])*Log[a^2 - (1/2)*(1 + Sqrt[5])*a*x + x^2])/(20*a^7)}
{1/(x^4*(a^5 + x^5)), x, 7, -(1/(3*a^5*x^3)) - (Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[((1 - Sqrt[5])*a - 4*x)/(Sqrt[2*(5 + Sqrt[5])]*a)])/(5*a^8) + (Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[(Sqrt[(1/10)*(5 + Sqrt[5])]*((1 + Sqrt[5])*a - 4*x))/(2*a)])/(5*a^8) + Log[a + x]/(5*a^8) - ((1 + Sqrt[5])*Log[a^2 - (1/2)*(1 - Sqrt[5])*a*x + x^2])/(20*a^8) - ((1 - Sqrt[5])*Log[a^2 - (1/2)*(1 + Sqrt[5])*a*x + x^2])/(20*a^8)}
{1/(x^m*(a^5 + x^5)), x, 1, (x^(1 - m)*Hypergeometric2F1[1, (1 - m)/5, (6 - m)/5, -(x^5/a^5)])/(a^5*(1 - m))}


(* ::Subsection::Closed:: *)
(*Problems 51 - 57 (p. 77-79)*)


{(x^4 + 1)/(x^6 + 1), x, 22, (-(1/3))*ArcTan[Sqrt[3] - 2*x] + (2*ArcTan[x])/3 + (1/3)*ArcTan[Sqrt[3] + 2*x]}
{1/(x^2 + 3*x + 5)^3, x, 4, (3 + 2*x)/(22*(5 + 3*x + x^2)^2) + (3*(3 + 2*x))/(121*(5 + 3*x + x^2)) + (12*ArcTan[(3 + 2*x)/Sqrt[11]])/(121*Sqrt[11])}
{(x^4 + x^2 + 1)/(x^2 + 1)^4, x, 4, x/(6*(1 + x^2)^3) - x/(24*(1 + x^2)^2) + (7*x)/(16*(1 + x^2)) + (7*ArcTan[x])/16}
{(A*x + B)/(a*x^2 + 2*b*x + c)^2, x, 3, -((b*B - A*c - (A*b - a*B)*x)/(2*(b^2 - a*c)*(c + 2*b*x + a*x^2))) - ((A*b - a*B)*ArcTanh[(b + a*x)/Sqrt[b^2 - a*c]])/(2*(b^2 - a*c)^(3/2))}
{(5*x^3 - 27*x^2 + 55*x - 41)/(x^2 - 4*x + 5)^2, x, 5, (1 - x)/(5 - 4*x + x^2) - 2*ArcTan[2 - x] + (5/2)*Log[5 - 4*x + x^2]}
{1/(x^3 - 1)^2, x, 7, x/(3*(1 - x^3)) + (2*ArcTan[(1 + 2*x)/Sqrt[3]])/(3*Sqrt[3]) - (2/9)*Log[1 - x] + (1/9)*Log[1 + x + x^2]}
{(3*x^4 + 4)/(x^2*(x^2 + 1)^3), x, 4, -(4/x) - (7*x)/(4*(1 + x^2)^2) - (25*x)/(8*(1 + x^2)) - (57*ArcTan[x])/8}


(* ::Subsection::Closed:: *)
(*Problems 58 - 65 (p. 80-81)*)


{x/(x^6 + 1), x, 7, -(ArcTan[(1 - 2*x^2)/Sqrt[3]]/(2*Sqrt[3])) + (1/6)*Log[1 + x^2] - (1/12)*Log[1 - x^2 + x^4]}
{(x^(n - 1) - 1)/(x^n - n*x), x, 5, Log[x^n - n*x]/n, Log[x] + Log[1 - n*x^(1 - n)]/n}
{x^3/(3*x^4 - 2*x^2 + 1), x, 5, -(ArcTan[(1 - 3*x^2)/Sqrt[2]]/(6*Sqrt[2])) + (1/12)*Log[1 - 2*x^2 + 3*x^4]}
{x^5/(3*x^4 + x^2 - 4), x, 5, x^2/6 + (1/14)*Log[1 - x^2] - (8/63)*Log[4 + 3*x^2]}
{x^2/(9 - 10*x^3 + x^6), x, 4, (-(1/24))*Log[1 - x^3] + (1/24)*Log[9 - x^3]}
{(x^3 - 4*x^2 + 1)/(x - 2)^4, x, 2, -(7/(3*(2 - x)^3)) + 2/(2 - x)^2 + 2/(2 - x) + Log[2 - x]}
{x^3/(x - 1)^12, x, 2, 1/(11*(1 - x)^11) - 3/(10*(1 - x)^10) + 1/(3*(1 - x)^9) - 1/(8*(1 - x)^8)}
{(x^4 - 3*x)/(1 + 2*x)^5, x, 3, -(25/(128*(1 + 2*x)^4)) + 7/(24*(1 + 2*x)^3) - 3/(32*(1 + 2*x)^2) + 1/(8*(1 + 2*x)) + (1/32)*Log[1 + 2*x]}


(* ::Subsection::Closed:: *)
(*Problems 66 - 70 (p. 83-78)*)


{1/((x + 1)^3*(x - 1)^2), x, 3, 1/(8*(1 - x)) - 1/(8*(1 + x)^2) - 1/(4*(1 + x)) + (3*ArcTanh[x])/8}
{1/(x^2*(5 - 6*x)^2), x, 2, 6/(25*(5 - 6*x)) - 1/(25*x) - (12/125)*Log[5 - 6*x] + (12*Log[x])/125}
{1/(x^2 - 2*x - 3)^3, x, 5, (1 - x)/(16*(3 + 2*x - x^2)^2) + (3*(1 - x))/(128*(3 + 2*x - x^2)) + (3/512)*Log[3 - x] - (3/512)*Log[1 + x]}
{1/(x^2 - 4*x + 13)^3, x, 4, -((2 - x)/(36*(13 - 4*x + x^2)^2)) - (2 - x)/(216*(13 - 4*x + x^2)) + (1/648)*ArcTan[(1/3)*(-2 + x)]}
{1/((x + 2)^3*(x + 3)^4), x, 2, -(1/(2*(2 + x)^2)) + 4/(2 + x) + 1/(3*(3 + x)^3) + 3/(2*(3 + x)^2) + 6/(3 + x) + 10*Log[2 + x] - 10*Log[3 + x]}


(* ::Subsection::Closed:: *)
(*Problems 71 - 82 (p. 86-87)*)


{x^6/(x^2 - 2)^2, x, 4, 4*x + x^3/3 - (2*x)/(x^2 - 2) - 5*Sqrt[2]*ArcTanh[x/Sqrt[2]], 5*x + (5*x^3)/6 + x^5/(2*(2 - x^2)) - 5*Sqrt[2]*ArcTanh[x/Sqrt[2]]}
{x^8/(x^2 + 4)^4, x, 5, (35*x)/16 - x^7/(6*(4 + x^2)^3) - (7*x^5)/(24*(4 + x^2)^2) - (35*x^3)/(48*(4 + x^2)) - (35/8)*ArcTan[x/2]}
{(7*x - 4)/(3*x^2 + 2*x + 5)^2, x, 3, -((39 + 19*x)/(28*(5 + 2*x + 3*x^2))) - (19*ArcTan[(1 + 3*x)/Sqrt[14]])/(28*Sqrt[14])}
{(5 - 4*x)/(3*x^2 - 4*x - 2)^2, x, 3, -((18 - 7*x)/(20*(2 + 4*x - 3*x^2))) - (7*ArcTanh[(2 - 3*x)/Sqrt[10]])/(20*Sqrt[10])}
{x^5/(x^4 + 1)^3, x, 4, -(x^2/(8*(1 + x^4)^2)) + x^2/(16*(1 + x^4)) + ArcTan[x^2]/16}
{x*((x^2 + 1)^3/(x^4 + 2*x^2 + 2)^2), x, 3, 1/(4*(x^4 + 2*x^2 + 2)) + (1/4)*Log[x^4 + 2*x^2 + 2], -((1 + x^2)^2/(4*(2 + 2*x^2 + x^4))) + (1/4)*Log[2 + 2*x^2 + x^4]}
{x^3/(a^4 + x^4)^3, x, 1, -(1/(8*(a^4 + x^4)^2))}
{1/(x*(a^4 + x^4)^3), x, 3, 1/(8*a^4*(a^4 + x^4)^2) + 1/(4*a^8*(a^4 + x^4)) + Log[x]/a^12 - Log[a^4 + x^4]/(4*a^12)}
{1/(x^2*(a^4 + x^4)^3), x, 12, -(45/(32*a^12*x)) + 1/(8*a^4*x*(a^4 + x^4)^2) + 9/(32*a^8*x*(a^4 + x^4)) + (45*ArcTan[1 - (Sqrt[2]*x)/a])/(64*Sqrt[2]*a^13) - (45*ArcTan[1 + (Sqrt[2]*x)/a])/(64*Sqrt[2]*a^13) - (45*Log[a^2 - Sqrt[2]*a*x + x^2])/(128*Sqrt[2]*a^13) + (45*Log[a^2 + Sqrt[2]*a*x + x^2])/(128*Sqrt[2]*a^13)}
{1/(x^3*(a^4 + x^4)^3), x, 5, -(15/(16*a^12*x^2)) + 1/(8*a^4*x^2*(a^4 + x^4)^2) + 5/(16*a^8*x^2*(a^4 + x^4)) - (15*ArcTan[x^2/a^2])/(16*a^14)}
{x^14/(3 + 2*x^5)^3, x, 3, -(9/(80*(3 + 2*x^5)^2)) + 3/(20*(3 + 2*x^5)) + (1/40)*Log[3 + 2*x^5]}
{x^6/(3 + 2*x^5)^3, x, 8, If[$VersionNumber<9, -(x^2/(20*(3 + 2*x^5)^2)) + x^2/(150*(3 + 2*x^5)) - (Sqrt[5 + Sqrt[5]]*ArcTan[Sqrt[(1/5)*(5 + 2*Sqrt[5])] - (2*2^(7/10)*x)/(3^(1/5)*Sqrt[5 - Sqrt[5]])])/(250*2^(9/10)*3^(3/5)) - (Sqrt[5 - Sqrt[5]]*ArcTan[Sqrt[(1/5)*(5 - 2*Sqrt[5])] + (2*2^(7/10)*x)/(3^(1/5)*Sqrt[5 + Sqrt[5]])])/(250*2^(9/10)*3^(3/5)) - Log[3^(1/5) + 2^(1/5)*x]/(250*2^(2/5)*3^(3/5)) + ((1 + Sqrt[5])*Log[2^(3/5)*3^(2/5) - (3/2)^(1/5)*(1 - Sqrt[5])*x + 2*x^2])/(1000*2^(2/5)*3^(3/5)) + ((1 - Sqrt[5])*Log[2^(3/5)*3^(2/5) - (3/2)^(1/5)*(1 + Sqrt[5])*x + 2*x^2])/(1000*2^(2/5)*3^(3/5)), -(x^2/(20*(3 + 2*x^5)^2)) + x^2/(150*(3 + 2*x^5)) - (Sqrt[5 + Sqrt[5]]*ArcTan[Sqrt[(1/5)*(5 + 2*Sqrt[5])] - (2*2^(7/10)*x)/(3^(1/5)*Sqrt[5 - Sqrt[5]])])/(250*2^(9/10)*3^(3/5)) - (Sqrt[5 - Sqrt[5]]*ArcTan[Sqrt[(1/5)*(5 - 2*Sqrt[5])] + (2*2^(7/10)*x)/(3^(1/5)*Sqrt[5 + Sqrt[5]])])/(250*2^(9/10)*3^(3/5)) - Log[3^(1/5) + 2^(1/5)*x]/(250*2^(2/5)*3^(3/5)) + ((1 + Sqrt[5])*Log[3^(2/5) - (3^(1/5)*(1 - Sqrt[5])*x)/2^(4/5) + 2^(2/5)*x^2])/(1000*2^(2/5)*3^(3/5)) + ((1 - Sqrt[5])*Log[3^(2/5) - (3^(1/5)*(1 + Sqrt[5])*x)/2^(4/5) + 2^(2/5)*x^2])/(1000*2^(2/5)*3^(3/5))]}


(* ::Subsection::Closed:: *)
(*Problems 83 - 87 (p. 90-91)*)


{9/(5*x^2*(3 - 2*x^2)^3), x, 5, -(1/(8*x)) + 3/(20*x*(3 - 2*x^2)^2) + 1/(8*x*(3 - 2*x^2)) + ArcTanh[Sqrt[2/3]*x]/(4*Sqrt[6])}
{(3*x^4 + 4)/(x^2*(x^2 + 1)^3), x, 4, -(4/x) - (7*x)/(4*(1 + x^2)^2) - (25*x)/(8*(1 + x^2)) - (57*ArcTan[x])/8}
{(5 - 3*x + 6*x^2 + 5*x^3 - x^4)/(x^5 - x^4 - 2*x^3 + 2*x^2 + x - 1), x, 2, -(3/(2*(1 - x)^2)) + 2/(1 - x) + 1/(1 + x) + Log[1 - x] - 2*Log[1 + x]}
{(x^2 + 1)/(x*(x^3 + 1)^2), x, 7, (x*(x - x^2))/(3*(x^3 + 1)) - ArcTan[(1 - 2*x)/Sqrt[3]]/(3*Sqrt[3]) + Log[x] - (4/9)*Log[1 + x] - (5/18)*Log[1 - x + x^2]}
{(x^2 - 3*x - 2)/((x + 1)^2*(x^2 + x + 1)^2), x, 7, -(2/(1 + x)) - (7 + 5*x)/(3*(1 + x + x^2)) - (25*ArcTan[(1 + 2*x)/Sqrt[3]])/(3*Sqrt[3]) - Log[1 + x] + (1/2)*Log[1 + x + x^2]}


(* ::Subsection::Closed:: *)
(*Problems 88 - 90 (p. 97)*)


{1/((2 - 3*x)*(1 - 4*x)^3), x, 2, 1/(10*(1 - 4*x)^2) - 3/(25*(1 - 4*x)) - (9/125)*Log[1 - 4*x] + (9/125)*Log[2 - 3*x]}
{x^3/(2 - 5*x^2)^7, x, 3, 1/(150*(2 - 5*x^2)^6) - 1/(250*(2 - 5*x^2)^5)}
{x^7/(2 - 5*x^2)^3, x, 3, -(x^2/250) + 2/(625*(2 - 5*x^2)^2) - 6/(625*(2 - 5*x^2)) - (3/625)*Log[2 - 5*x^2]}


(* ::Section::Closed:: *)
(*Chapter 3 Integration Problems*)


(* ::Subsection::Closed:: *)
(*Problems 1 - 3 (p. 101)*)


{1/((x - 2)^3*(x + 1)^2), x, 2, -1/(18*(x - 2)^2) + 2/(27*(x - 2)) + 1/(27*(x + 1)) + Log[x - 2]/27 - Log[x + 1]/27, -(1/(18*(2 - x)^2)) - 2/(27*(2 - x)) + 1/(27*(1 + x)) + (1/27)*Log[2 - x] - (1/27)*Log[1 + x]}
{1/((x + 2)^3*(x + 3)^4), x, 2, -1/(2*(x + 2)^2) + 4/(x + 2) + 1/(3*(x + 3)^3) + 3/(2*(x + 3)^2) + 6/(x + 3) + 10*Log[x + 2] - 10*Log[x + 3]}
{x^5/(3 + x)^2, x, 2, -108*x + (27*x^2)/2 - 2*x^3 + x^4/4 + 243/(3 + x) + 405*Log[3 + x]}


(* ::Subsection::Closed:: *)
(*Problems 4 - 9 (p. 105)*)


{(b1 + c1*x)*(a + 2*b*x + c*x^2)^1, x, 2, a*b1*x + (1/2)*(2*b*b1 + a*c1)*x^2 + (1/3)*(b1*c + 2*b*c1)*x^3 + (1/4)*c*c1*x^4}
{(b1 + c1*x)*(a + 2*b*x + c*x^2)^2, x, 2, a^2*b1*x + (1/2)*a*(4*b*b1 + a*c1)*x^2 + (2/3)*(2*b^2*b1 + a*b1*c + 2*a*b*c1)*x^3 + (1/2)*(2*b*b1*c + 2*b^2*c1 + a*c*c1)*x^4 + (1/5)*c*(b1*c + 4*b*c1)*x^5 + (1/6)*c^2*c1*x^6}
{(b1 + c1*x)*(a + 2*b*x + c*x^2)^3, x, 2, a^3*b1*x + (1/2)*a^2*(6*b*b1 + a*c1)*x^2 + a*(4*b^2*b1 + a*b1*c + 2*a*b*c1)*x^3 + (1/4)*(8*b^3*b1 + 12*a*b*b1*c + 12*a*b^2*c1 + 3*a^2*c*c1)*x^4 + (1/5)*(12*b^2*b1*c + 3*a*b1*c^2 + 8*b^3*c1 + 12*a*b*c*c1)*x^5 + (1/2)*c*(2*b*b1*c + 4*b^2*c1 + a*c*c1)*x^6 + (1/7)*c^2*(b1*c + 6*b*c1)*x^7 + (1/8)*c^3*c1*x^8}
{(b1 + c1*x)*(a + 2*b*x + c*x^2)^4, x, 2, a^4*b1*x + (1/2)*a^3*(8*b*b1 + a*c1)*x^2 + (4/3)*a^2*(6*b^2*b1 + a*b1*c + 2*a*b*c1)*x^3 + a*(8*b^3*b1 + 6*a*b*b1*c + 6*a*b^2*c1 + a^2*c*c1)*x^4 + (2/5)*(8*b^4*b1 + 24*a*b^2*b1*c + 3*a^2*b1*c^2 + 16*a*b^3*c1 + 12*a^2*b*c*c1)*x^5 + (1/3)*(16*b^3*b1*c + 12*a*b*b1*c^2 + 8*b^4*c1 + 24*a*b^2*c*c1 + 3*a^2*c^2*c1)*x^6 + (4/7)*c*(6*b^2*b1*c + a*b1*c^2 + 8*b^3*c1 + 6*a*b*c*c1)*x^7 + (1/2)*c^2*(2*b*b1*c + 6*b^2*c1 + a*c*c1)*x^8 + (1/9)*c^3*(b1*c + 8*b*c1)*x^9 + (1/10)*c^4*c1*x^10}
{(b1 + c1*x)*(a + 2*b*x + c*x^2)^n, x, 2, (c1*(a + 2*b*x + c*x^2)^(n + 1))/(2*c*(n + 1)) - (((b1*c - b*c1)*(a + 2*b*x + c*x^2)^(n + 1))/(2*c*(n + 1)*Sqrt[b^2 - a*c]*(-((b + c*x - Sqrt[b^2 - a*c])/(2*Sqrt[b^2 - a*c])))^(n + 1)))*Hypergeometric2F1[-n, 1 + n, 2 + n, (b + c*x + Sqrt[b^2 - a*c])/(2*Sqrt[b^2 - a*c])]}
{(b1 + c1*x)/(a + 2*b*x + c*x^2)^1, x, 4, -(((b1*c - b*c1)*ArcTanh[(b + c*x)/Sqrt[b^2 - a*c]])/(c*Sqrt[b^2 - a*c])) + (c1*Log[a + 2*b*x + c*x^2])/(2*c)}
{(b1 + c1*x)/(a + 2*b*x + c*x^2)^2, x, 3, -((b*b1 - a*c1 + (b1*c - b*c1)*x)/(2*(b^2 - a*c)*(a + 2*b*x + c*x^2))) + ((b1*c - b*c1)*ArcTanh[(b + c*x)/Sqrt[b^2 - a*c]])/(2*(b^2 - a*c)^(3/2))}
{(b1 + c1*x)/(a + 2*b*x + c*x^2)^3, x, 4, -((b*b1 - a*c1 + (b1*c - b*c1)*x)/(4*(b^2 - a*c)*(a + 2*b*x + c*x^2)^2)) + (3*(b1*c - b*c1)*(b + c*x))/(8*(b^2 - a*c)^2*(a + 2*b*x + c*x^2)) - (3*c*(b1*c - b*c1)*ArcTanh[(b + c*x)/Sqrt[b^2 - a*c]])/(8*(b^2 - a*c)^(5/2))}
{(b1 + c1*x)/(a + 2*b*x + c*x^2)^4, x, 5, -((b*b1 - a*c1 + (b1*c - b*c1)*x)/(6*(b^2 - a*c)*(a + 2*b*x + c*x^2)^3)) + (5*(b1*c - b*c1)*(b + c*x))/(24*(b^2 - a*c)^2*(a + 2*b*x + c*x^2)^2) - (5*c*(b1*c - b*c1)*(b + c*x))/(16*(b^2 - a*c)^3*(a + 2*b*x + c*x^2)) + (5*c^2*(b1*c - b*c1)*ArcTanh[(b + c*x)/Sqrt[b^2 - a*c]])/(16*(b^2 - a*c)^(7/2))}
{(b1 + c1*x)/(a + 2*b*x + c*x^2)^n, x, 2, (c1*(a + 2*b*x + c*x^2)^(1 - n))/(2*c*(1 - n)) - ((b1*c - b*c1)*(-((b - Sqrt[b^2 - a*c] + c*x)/Sqrt[b^2 - a*c]))^(-1 + n)*(a + 2*b*x + c*x^2)^(1 - n)*Hypergeometric2F1[1 - n, n, 2 - n, (b + Sqrt[b^2 - a*c] + c*x)/(2*Sqrt[b^2 - a*c])])/(2^n*(c*Sqrt[b^2 - a*c]*(1 - n)))}
{x/(3 + 6*x + 2*x^2), x, 3, (1/4)*(1 - Sqrt[3])*Log[3 - Sqrt[3] + 2*x] + (1/4)*(1 + Sqrt[3])*Log[3 + Sqrt[3] + 2*x]}
{(2*x - 3)/(3 + 6*x + 2*x^2)^3, x, 4, (5 + 4*x)/(4*(3 + 6*x + 2*x^2)^2) - (3 + 2*x)/(2*(3 + 6*x + 2*x^2)) + ArcTanh[(3 + 2*x)/Sqrt[3]]/Sqrt[3]}
{(x - 1)/(x^2 + 5*x + 4)^2, x, 4, (7*x + 13)/(9*(x^2 + 5*x + 4)) + (7*Log[x + 1])/27 - (7*Log[x + 4])/27}
{1/(x^2 + 3*x + 2)^5, x, 7, -(2*x + 3)/(4*(x^2 + 3*x + 2)^4) + (7*(2*x + 3))/(6*(x^2 + 3*x + 2)^3) - (35*(2*x + 3))/(6*(x^2 + 3*x + 2)^2) + (35*(2*x + 3))/(x^2 + 3*x + 2) + 70*Log[x + 1] - 70*Log[x + 2]}


(* ::Subsection::Closed:: *)
(*Problems 10 - 12 (p. 109)*)


{1/(x^3*(7 - 6*x + 2*x^2)^2), x, 7, -1/(490*x^2) - 69/(1715*x) - (2 - 3*x)/(35*x^2*(7 - 6*x + 2*x^2)) - (234*ArcTan[(3 - 2*x)/Sqrt[5]])/(12005*Sqrt[5]) + (80*Log[x])/2401 - (40*Log[7 - 6*x + 2*x^2])/2401}
{x^9/(x^2 + 3*x + 2)^5, x, 8, 735*x + (x^8*(4 + 3*x))/(4*(2 + 3*x + x^2)^4) - (x^6*(110 + 81*x))/(12*(2 + 3*x + x^2)^3) + (x^4*(184 + 135*x))/(2*(2 + 3*x + x^2)^2) - (x^2*(2206 + 1593*x))/(2*(2 + 3*x + x^2)) - 1471*Log[1 + x] + 1472*Log[2 + x]}
{(1 + 2*x)^2/(3 + 5*x + 2*x^2)^5, x, 7, ((1 + 2*x)*(7 + 6*x))/(4*(3 + 5*x + 2*x^2)^4) + (73 + 62*x)/(3*(3 + 5*x + 2*x^2)^3) - (155*(5 + 4*x))/(3*(3 + 5*x + 2*x^2)^2) + (620*(5 + 4*x))/(3 + 5*x + 2*x^2) + 2480*Log[x + 1] - 2480*Log[2*x + 3]}


(* ::Subsection::Closed:: *)
(*Problems 13 - 14 (p. 113)*)


{(a - b*x^2)^3/x^7, x, 3, -a^3/(6*x^6) + (3*a^2*b)/(4*x^4) - (3*a*b^2)/(2*x^2) - b^3*Log[x]}
{x^13/(a^4 + x^4)^5, x, 6, -x^10/(16*(a^4 + x^4)^4) - (5*x^6)/(96*(a^4 + x^4)^3) - (5*x^2)/(128*(a^4 + x^4)^2) + (5*x^2)/(256*a^4*(a^4 + x^4)) + (5*ArcTan[x^2/a^2])/(256*a^6)}


(* ::Section::Closed:: *)
(*Chapter 4 Integration Problems*)


(* ::Subsection::Closed:: *)
(*Problems 1 - 9 (p. 115-116)*)


{x^(3/2)*(1 + x^2)*(2*Sqrt[x] - x)^2, x, 9, (8*x^(7/2))/7 - x^4 + (2*x^(9/2))/9 + (8*x^(11/2))/11 - (2*x^6)/3 + (2*x^(13/2))/13}
{(x^(3/2) - 3*x^(3/5))^2*(4*x^(3/2) - (1/3)*x^(2/3)), x, 5, -((45*x^(43/15))/43) + (360*x^(37/10))/37 + (60*x^(113/30))/113 - (120*x^(23/5))/23 - x^(14/3)/14 + (8*x^(11/2))/11}
{1/(1 + Sqrt[1 + x]), x, 4, 2*Sqrt[1 + x] - 2*Log[1 + Sqrt[1 + x]]}
{x/(1 + Sqrt[1 + x]), x, 2, (2/3)*(1 + x)^(3/2) - x}
{(Sqrt[1 + x] + 1)/(Sqrt[1 + x] - 1), x, 4, x + 4*Sqrt[1 + x] + 4*Log[1 - Sqrt[1 + x]]}
{1/((1 + x)^(2/3) - Sqrt[1 + x]), x, 5, 6*(1 + x)^(1/6) + 3*(1 + x)^(1/3) + 6*Log[1 - (1 + x)^(1/6)]}
{(1 + x^(1/4))^(1/3)/Sqrt[x], x, 3, (12/7)*(1 + x^(1/4))^(7/3) - 3*(1 + x^(1/4))^(4/3)}
{1/(x^3*(1 + x)^(3/2)), x, 5, 15/(4*Sqrt[1 + x]) - 1/(2*x^2*Sqrt[1 + x]) + 5/(4*x*Sqrt[1 + x]) - (15/4)*ArcTanh[Sqrt[1 + x]]}
{1/(x^5*(1 - x)^(7/2)), x, 9, 3003/(320*(1 - x)^(5/2)) + 1001/(64*(1 - x)^(3/2)) + 3003/(64*Sqrt[1 - x]) - 1/(4*(1 - x)^(5/2)*x^4) - 13/(24*(1 - x)^(5/2)*x^3) - 143/(96*(1 - x)^(5/2)*x^2) - 429/(64*(1 - x)^(5/2)*x) - (3003/64)*ArcTanh[Sqrt[1 - x]]}


(* ::Subsection::Closed:: *)
(*Problems 10 - 12 (p. 117-118)*)


{1/(x^5*(x - 1)^(2/3)), x, 8, (x - 1)^(1/3)/(4*x^4) + (11*(x - 1)^(1/3))/(36*x^3) + (11*(x - 1)^(1/3))/(27*x^2) + (55*(x - 1)^(1/3))/(81*x) - 110/(81*Sqrt[3])*ArcTan[(1 - 2*(x - 1)^(1/3))/Sqrt[3]] + (55/81)*Log[1 + (x - 1)^(1/3)] - (55*Log[x])/243}
{Sqrt[(1 - x)/(1 + x)], x, 3, (1 + x)*Sqrt[(1 - x)/(1 + x)] - 2*ArcTan[Sqrt[(1 - x)/(1 + x)]]}
{Sqrt[(x - a)/(b - x)]*x, x, 4, (1/4)*(a - 5*b)*Sqrt[(x - a)/(b - x)]*(b - x) + (1/2)*Sqrt[(x - a)/(b - x)]*(b - x)^2 - (1/4)*(a - b)*(a + 3*b)*ArcTan[Sqrt[(x - a)/(b - x)]], (1/4)*(a - 5*b)*Sqrt[-((a - x)/(b - x))]*(b - x) + (1/2)*Sqrt[-((a - x)/(b - x))]*(b - x)^2 - (1/4)*(a - b)*(a + 3*b)*ArcTan[Sqrt[-((a - x)/(b - x))]]}


(* ::Subsection::Closed:: *)
(*Problems 13 - 15 (p. 119-120)*)


{Sqrt[x - 5]*(Sqrt[x + 3]/((x - 1)*(x^2 - 25))), x, 6, (1/6)*ArcTan[(1/4)*Sqrt[-5 + x]*Sqrt[3 + x]] + ArcTanh[(Sqrt[5]*Sqrt[3 + x])/Sqrt[-5 + x]]/(3*Sqrt[5])}
{x^2*(1 - x^2)^(1/4)*Sqrt[1 + x]/(Sqrt[1 - x]*(Sqrt[1 - x] - Sqrt[1 + x])), x, 33, (5/16)*(1 - x)^(3/4)*(1 + x)^(1/4) - (1/16)*(1 - x)^(1/4)*(1 + x)^(3/4) + (1/24)*(1 - x)^(5/4)*(1 + x)^(3/4) + (7*(1 - x^2)^(5/4))/(24*Sqrt[1 - x]) + (x*(1 - x^2)^(5/4))/(6*Sqrt[1 - x]) + (1/6)*Sqrt[1 + x]*(1 - x^2)^(5/4) - (3*ArcTan[1 - (Sqrt[2]*(1 - x)^(1/4))/(1 + x)^(1/4)])/(8*Sqrt[2]) + (3*ArcTan[1 + (Sqrt[2]*(1 - x)^(1/4))/(1 + x)^(1/4)])/(8*Sqrt[2]) + Log[1 + Sqrt[1 - x]/Sqrt[1 + x] - (Sqrt[2]*(1 - x)^(1/4))/(1 + x)^(1/4)]/(8*Sqrt[2]) - Log[1 + Sqrt[1 - x]/Sqrt[1 + x] + (Sqrt[2]*(1 - x)^(1/4))/(1 + x)^(1/4)]/(8*Sqrt[2]), (-(5/48))*(1 - x)^(3/4)*(1 + x)^(1/4) + (5/24)*(1 - x)^(7/4)*(1 + x)^(1/4) - (1/16)*(1 - x)^(1/4)*(1 + x)^(3/4) + (1/24)*(1 - x)^(5/4)*(1 + x)^(3/4) + (1/6)*(1 - x)^(7/4)*(1 + x)^(5/4) + (1/6)*Sqrt[1 + x]*(1 - x^2)^(5/4) + (1 - x^2)^(9/4)/(3*(1 - x)^(3/2)) - (3*ArcTan[1 - (Sqrt[2]*(1 - x)^(1/4))/(1 + x)^(1/4)])/(8*Sqrt[2]) + (3*ArcTan[1 + (Sqrt[2]*(1 - x)^(1/4))/(1 + x)^(1/4)])/(8*Sqrt[2]) + Log[1 + Sqrt[1 - x]/Sqrt[1 + x] - (Sqrt[2]*(1 - x)^(1/4))/(1 + x)^(1/4)]/(8*Sqrt[2]) - Log[1 + Sqrt[1 - x]/Sqrt[1 + x] + (Sqrt[2]*(1 - x)^(1/4))/(1 + x)^(1/4)]/(8*Sqrt[2])}
{x*(1 + x)^(2/3)*Sqrt[1 - x]/(Sqrt[1 + x]*(1 - x)^(2/3) - (1 + x)^(1/3)*(1 - x)^(5/6)), x, If[$VersionNumber>=8, -46, -4], (-(1/12))*(1 - 3*x)*(1 - x)^(2/3)*(1 + x)^(1/3) + (1/4)*Sqrt[1 - x]*x*Sqrt[1 + x] - (1/4)*(1 - x)*(3 + x) + (1/12)*(1 - x)^(1/3)*(1 + x)^(2/3)*(1 + 3*x) + (1/12)*(1 - x)^(1/6)*(1 + x)^(5/6)*(2 + 3*x) - (1/12)*(1 - x)^(5/6)*(1 + x)^(1/6)*(10 + 3*x) + (1/6)*ArcTan[(1 + x)^(1/6)/(1 - x)^(1/6)] - (4*ArcTan[((1 - x)^(1/3) - 2*(1 + x)^(1/3))/(Sqrt[3]*(1 - x)^(1/3))])/(3*Sqrt[3]) - (5/6)*ArcTan[((1 - x)^(1/3) - (1 + x)^(1/3))/((1 - x)^(1/6)*(1 + x)^(1/6))] + ArcTanh[(Sqrt[3]*(1 - x)^(1/6)*(1 + x)^(1/6))/((1 - x)^(1/3) + (1 + x)^(1/3))]/(6*Sqrt[3])}


(* ::Subsection::Closed:: *)
(*Problems 16 - 21 (p. 127)*)


{1/((x + 1)^2*(x - 1)^4)^(1/3), x, 2, -((3*(x - 1)*(x + 1))/(2*((x + 1)^2*(x - 1)^4)^(1/3))), (3*(1 - x)*(1 + x))/(2*((1 - x)^4*(1 + x)^2)^(1/3))}
{1/((x - 1)^3*(x + 2)^5)^(1/4), x, 2, (4*(x - 1)*(2 + x))/(3*((x - 1)^3*(x + 2)^5)^(1/4)), -((4*(1 - x)*(2 + x))/(3*((-(1 - x)^3)*(2 + x)^5)^(1/4)))}
{1/((x + 1)^2*(x - 1)^7)^(1/3), x, 3, -((3*(x - 1)*(x + 1))/(8*((x + 1)^2*(x - 1)^7)^(1/3))) + (9*(x - 1)^2*(x + 1))/(16*((x + 1)^2*(x - 1)^7)^(1/3)), (3*(1 - x)*(1 + x))/(8*((-(1 - x)^7)*(1 + x)^2)^(1/3)) + (9*(1 - x)^2*(1 + x))/(16*((-(1 - x)^7)*(1 + x)^2)^(1/3))}
{1/((x - 1)^2*(x + 1))^(1/3), x, -3, Sqrt[3]*ArcTan[(1/Sqrt[3])*(1 + (2*(x - 1))/((x - 1)^2*(x + 1))^(1/3))] - (1/2)*Log[x + 1] - (3/2)*Log[1 - (x - 1)/((x - 1)^2*(x + 1))^(1/3)]}
{(x + 1/x)/Sqrt[(x + 1)^3*(x - 2)], x, 9, -((4*(x - 2)*(x + 1))/(3*Sqrt[(x + 1)^3*(x - 2)])) + (2*Sqrt[x - 2]*(x + 1)^(3/2)*ArcSinh[Sqrt[x - 2]/Sqrt[3]])/Sqrt[(x + 1)^3*(x - 2)] - (Sqrt[2]*Sqrt[x - 2]*(x + 1)^(3/2)*ArcTan[(Sqrt[2]*Sqrt[x + 1])/Sqrt[x - 2]])/Sqrt[(x + 1)^3*(x - 2)], (4*(2 - x)*(1 + x))/(3*Sqrt[-((2 - x)*(1 + x)^3)]) + (2*Sqrt[-2 + x]*(1 + x)^(3/2)*ArcSinh[Sqrt[-2 + x]/Sqrt[3]])/Sqrt[-((2 - x)*(1 + x)^3)] - (Sqrt[2]*Sqrt[-2 + x]*(1 + x)^(3/2)*ArcTan[(Sqrt[2]*Sqrt[1 + x])/Sqrt[-2 + x]])/Sqrt[-((2 - x)*(1 + x)^3)]}
{((x - 1)^2*(x + 1))^(1/3)/x^2, x, -6, -(((x - 1)^2*(x + 1))^(1/3)/x) - (1/Sqrt[3])*ArcTan[(1/Sqrt[3])*(1 - (2*(x - 1))/((x - 1)^2*(x + 1))^(1/3))] - Sqrt[3]*ArcTan[(1/Sqrt[3])*(1 + (2*(x - 1))/((x - 1)^2*(x + 1))^(1/3))] + Log[x]/6 - (2/3)*Log[x + 1] - (3/2)*Log[1 - (x - 1)/((x - 1)^2*(1 + x))^(1/3)] - (1/2)*Log[1 + (x - 1)/((x - 1)^2*(1 + x))^(1/3)]}


(* ::Subsection::Closed:: *)
(*Problems 22 - 27 (p. 128)*)


{1/(x^2 - 2*x - 3)^(5/2), x, 2, (1 - x)/(12*(x^2 - 2*x - 3)^(3/2)) - (1 - x)/(24*Sqrt[x^2 - 2*x - 3])}
{1/Sqrt[x^3 - 5*x^2 + 3*x + 9], x, 4, ((3 - x)*Sqrt[1 + x]*ArcTanh[Sqrt[1 + x]/2])/Sqrt[x^3 - 5*x^2 + 3*x + 9]}
{1/(x^3 - 5*x^2 + 3*x + 9)^(3/2), x, 7, ((3 - x)*(1 + x))/(8*(x^3 - 5*x^2 + 3*x + 9)^(3/2)) + (5*(3 - x)^2*(1 + x))/(64*(x^3 - 5*x^2 + 3*x + 9)^(3/2)) - (15*(3 - x)^3*(1 + x))/(256*(x^3 - 5*x^2 + 3*x + 9)^(3/2)) + (15*(3 - x)^3*(1 + x)^(3/2)*ArcTanh[Sqrt[1 + x]/2])/(512*(x^3 - 5*x^2 + 3*x + 9)^(3/2))}
{1/(x^3 - 5*x^2 + 3*x + 9)^(1/3), x, -3, Sqrt[3]*ArcTan[(1/Sqrt[3])*(1 + (2*(x - 3))/(x^3 - 5*x^2 + 3*x + 9)^(1/3))] - (1/2)*Log[x + 1] - (3/2)*Log[1 - (x - 3)/(x^3 - 5*x^2 + 3*x + 9)^(1/3)]}
{1/(x^3 - 5*x^2 + 3*x + 9)^(2/3), x, 3, (3*(3 - x)*(1 + x))/(4*(x^3 - 5*x^2 + 3*x + 9)^(2/3))}
{1/(x^3 - 5*x^2 + 3*x + 9)^(4/3), x, 5, (3*(3 - x)*(1 + x))/(20*(x^3 - 5*x^2 + 3*x + 9)^(4/3)) + (9*(3 - x)^2*(1 + x))/(80*(x^3 - 5*x^2 + 3*x + 9)^(4/3)) - (27*(3 - x)^3*(1 + x))/(320*(x^3 - 5*x^2 + 3*x + 9)^(4/3))}


(* ::Subsection::Closed:: *)
(*Problems 28 - 37 (p. 143-144)*)


{1/Sqrt[4 + 3*x - 2*x^2], x, 2, -1/Sqrt[2]*ArcSin[(3 - 4*x)/Sqrt[41]]}
{1/Sqrt[-3 + 4*x - x^2], x, 2, -ArcSin[2 - x]}
{1/Sqrt[-2 - 5*x - 3*x^2], x, 2, ArcSin[5 + 6*x]/Sqrt[3]}
{1/((x^2 + 4)*Sqrt[1 - x^2]), x, 2, ArcTan[(Sqrt[5]*x)/(2*Sqrt[1 - x^2])]/(2*Sqrt[5])}
{1/((x^2 + 4)*Sqrt[4*x^2 + 1]), x, 2, 1/(2*Sqrt[15])*ArcTanh[(Sqrt[15]*x)/(2*Sqrt[1 + 4*x^2])]}
{x/((3 - x^2)*Sqrt[5 - x^2]), x, 3, 1/Sqrt[2]*ArcTanh[Sqrt[5 - x^2]/Sqrt[2]]}
{x/((5 - x^2)*Sqrt[3 - x^2]), x, 3, -1/Sqrt[2]*ArcTan[Sqrt[3 - x^2]/Sqrt[2]]}
{1/((x^4 - 1)*Sqrt[x^2 + 2]), x, 5, -1/2*ArcTan[x/Sqrt[2 + x^2]] - 1/(2*Sqrt[3])*ArcTanh[(Sqrt[3]*x)/Sqrt[2 + x^2]]}
{x/((x^2 - 1)*Sqrt[x^2 + 2*x + 4]), x, 5, -1/(2*Sqrt[7])*ArcTanh[(5 + 2*x)/(Sqrt[7]*Sqrt[x^2 + 2*x + 4])] - 1/(2*Sqrt[3])*ArcTanh[Sqrt[x^2 + 2*x + 4]/Sqrt[3]]}
{1/((x^3 - 8)*Sqrt[x^2 + 2*x + 5]), x, 9, -1/(4*Sqrt[3])*ArcTan[(1 + x)/(Sqrt[3]*Sqrt[x^2 + 2*x + 5])] - 1/(12*Sqrt[13])*ArcTanh[(7 + 3*x)/(Sqrt[13]*Sqrt[x^2 + 2*x + 5])] + 1/12*ArcTanh[Sqrt[x^2 + 2*x + 5]]}


(* ::Subsection::Closed:: *)
(*Problems 38 - 42 (p. 145-146)*)


{x/((x^2 + x + 4)*Sqrt[4*x^2 + 4*x + 5]), x, 5, (1/Sqrt[11])*ArcTan[Sqrt[4*x^2 + 4*x + 5]/Sqrt[11]] - (1/Sqrt[165])*ArcTanh[(Sqrt[11/15]*(2*x + 1))/Sqrt[4*x^2 + 4*x + 5]]}
{(x + 3)/((x^2 + 1)*Sqrt[x^2 + x + 1]), x, 5, -2*Sqrt[2]*ArcTan[(1 - x)/(Sqrt[2]*Sqrt[1 + x + x^2])] + Sqrt[2]*ArcTanh[(1 + x)/(Sqrt[2]*Sqrt[1 + x + x^2])]}
{(2*x + 1)/((3*x^2 + 4*x + 4)*Sqrt[x^2 + 6*x - 1]), x, 5, (-(5/(6*Sqrt[14])))*ArcTan[(Sqrt[7]*(2 - x))/(2*Sqrt[2]*Sqrt[x^2 + 6*x - 1])] - (1/(3*Sqrt[7]))*ArcTanh[(Sqrt[7]*(1 + x))/Sqrt[x^2 + 6*x - 1]]}
{(A*x + B)/((5*x^2 - 18*x + 17)*Sqrt[10*x^2 - 22*x + 13]), x, 5, (-((2*A + B)/Sqrt[35]))*ArcTan[(Sqrt[35]*(2 - x))/Sqrt[10*x^2 - 22*x + 13]] - ((A + B)/(2*Sqrt[35]))*ArcTanh[(Sqrt[35]*(1 - x))/(2*Sqrt[10*x^2 - 22*x + 13])], -(((2*A + B)*ArcTan[(Sqrt[35]*(2 - x))/Sqrt[13 - 22*x + 10*x^2]])/Sqrt[35]) - ((A + B)*ArcTanh[(Sqrt[35]*(A + B - (A + B)*x))/(2*(A + B)*Sqrt[13 - 22*x + 10*x^2])])/(2*Sqrt[35])}
{(x - 2)/((5*x^2 - 18*x + 17)*Sqrt[10*x^2 - 22*x + 13]), x, 2, (1/(2*Sqrt[35]))*ArcTanh[(Sqrt[35]*(1 - x))/(2*Sqrt[10*x^2 - 22*x + 13])]}


(* ::Subsection::Closed:: *)
(*Problems 43 - 49 (p. 163)*)


{x^4*Sqrt[5 - x^2], x, 4, -25/16*x*Sqrt[5 - x^2] - (5/24)*x^3*Sqrt[5 - x^2] + (1/6)*x^5*Sqrt[5 - x^2] + (125/16)*ArcSin[x/Sqrt[5]]}
{1/(x^6*Sqrt[x^2 + 2]), x, 3, -(Sqrt[x^2 + 2]/(10*x^5)) + Sqrt[x^2 + 2]/(15*x^3) - Sqrt[x^2 + 2]/(15*x)}
{1/(2*x^2 + 3)^(7/2), x, 3, x/(15*(2*x^2 + 3)^(5/2)) + (4*x)/(135*(2*x^2 + 3)^(3/2)) + (8*x)/(405*Sqrt[2*x^2 + 3])}
{x/(1 + x^2 + a*Sqrt[1 + x^2]), x, 3, Log[a + Sqrt[1 + x^2]]}
{(x^2 - x + 1)/((1 + x^2)*Sqrt[1 + x^2]), x, 2, 1/Sqrt[1 + x^2] + ArcSinh[x]}
{Sqrt[1 + x^2]/(2 + x^2), x, 4, ArcSinh[x] - 1/Sqrt[2]*ArcTanh[x/(Sqrt[2]*Sqrt[1 + x^2])]}
{1/((2 + x^2)^2*Sqrt[1 + x^2]), x, 3, -((x*Sqrt[1 + x^2])/(4*(2 + x^2))) + 3/(4*Sqrt[2])*ArcTanh[x/(Sqrt[2]*Sqrt[1 + x^2])]}


(* ::Subsection::Closed:: *)
(*Problems 50 - 62 (p. 164)*)


{x^2/((x^2 - 6)*Sqrt[x^2 - 2]), x, 5, ArcTanh[x/Sqrt[x^2 - 2]] - Sqrt[3/2]*ArcTanh[(Sqrt[2/3]*x)/Sqrt[x^2 - 2]]}
{(x^2 + 5)/((1 + x^2)^2*Sqrt[1 - x^2]), x, 4, (x*Sqrt[1 - x^2])/(1 + x^2) + 2*Sqrt[2]*ArcTan[(Sqrt[2]*x)/Sqrt[1 - x^2]]}
{(4*x - Sqrt[1 - x^2])/(5 + Sqrt[1 - x^2]), x, 15, -x - 4*Sqrt[1 - x^2] + 5*ArcSin[x] + (25*ArcTan[x/(2*Sqrt[6])])/(2*Sqrt[6]) - (25*ArcTan[(5*x)/(2*Sqrt[6]*Sqrt[1 - x^2])])/(2*Sqrt[6]) + 20*Log[5 + Sqrt[1 - x^2]]}
{(2 - Sqrt[x^2 + 1])*(x^2/(Sqrt[x^2 + 1]*((x^2 + 1)^(3/2) - x^3 + 1))), x, 32, (8*x)/9 - x^2/6 + (8*Sqrt[x^2 + 1])/9 - (1/6)*x*Sqrt[x^2 + 1] - (41*ArcSinh[x])/54 + (4/27)*Sqrt[2]*ArcTan[(1 + 3*x)/(2*Sqrt[2])] + (4/27)*Sqrt[2]*ArcTan[(1 + x)/(Sqrt[2]*Sqrt[x^2 + 1])] + (7/27)*ArcTanh[(1 - x)/(2*Sqrt[x^2 + 1])] - (7/54)*Log[3 + 2*x + 3*x^2]}
{x*Sqrt[2*r*x - x^2], x, 4, (-(1/2))*r*(r - x)*Sqrt[2*r*x - x^2] - (1/3)*(2*r*x - x^2)^(3/2) + r^3*ArcTan[x/Sqrt[2*r*x - x^2]]}
{x^2*Sqrt[2*r*x - x^2], x, 5, -5/8*r^2*(r - x)*Sqrt[2*r*x - x^2] - (5/12)*r*(2*r*x - x^2)^(3/2) - (1/4)*x*(2*r*x - x^2)^(3/2) + (5/4)*r^4*ArcTan[x/Sqrt[2*r*x - x^2]]}
{x^3*Sqrt[2*r*x - x^2], x, 6, (-(7/8))*r^3*(r - x)*Sqrt[2*r*x - x^2] - (7/12)*r^2*(2*r*x - x^2)^(3/2) - (7/20)*r*x*(2*r*x - x^2)^(3/2) - (1/5)*x^2*(2*r*x - x^2)^(3/2) + (7/4)*r^5*ArcTan[x/Sqrt[2*r*x - x^2]]}
{1/((x^2 - 1)*Sqrt[2*x + x^2]), x, 5, (-(1/2))*ArcTan[Sqrt[2*x + x^2]] - 1/(2*Sqrt[3])*ArcTanh[(1 + 2*x)/(Sqrt[3]*Sqrt[2*x + x^2])]}
{(3*x - 2)/((x + 1)^3*Sqrt[2*x - x^2]), x, 4, -((5*Sqrt[2*x - x^2])/(6*(1 + x)^2)) - (2*Sqrt[2*x - x^2])/(3*(1 + x)) + 1/(2*Sqrt[3])*ArcTan[(1 - 2*x)/(Sqrt[3]*Sqrt[2*x - x^2])]}
{1/Sqrt[1 + x + x^2], x, 2, ArcSinh[(1 + 2*x)/Sqrt[3]]}
{x^3/Sqrt[1 + x + x^2], x, 4, (1/3)*x^2*Sqrt[1 + x + x^2] - (1/24)*(1 + 10*x)*Sqrt[1 + x + x^2] + (7/16)*ArcSinh[(1 + 2*x)/Sqrt[3]]}
{1/(1 + x + x^2)^(3/2), x, 1, (2*(1 + 2*x))/(3*Sqrt[1 + x + x^2])}
{x/(1 + x + x^2)^(3/2), x, 1, -((2*(2 + x))/(3*Sqrt[1 + x + x^2]))}


(* ::Subsection::Closed:: *)
(*Problems 63 - 72 (p. 165)*)


{x^3/(1 + x + x^2)^(3/2), x, 4, -((2*x^2*(2 + x))/(3*Sqrt[1 + x + x^2])) + (1/3)*(5 + 2*x)*Sqrt[1 + x + x^2] - (3/2)*ArcSinh[(1 + 2*x)/Sqrt[3]]}
{x^2*Sqrt[1 + x + x^2], x, 5, (1/64)*(1 + 2*x)*Sqrt[1 + x + x^2] - (5/24)*(1 + x + x^2)^(3/2) + (1/4)*x*(1 + x + x^2)^(3/2) + (3/128)*ArcSinh[(1 + 2*x)/Sqrt[3]]}
{(1 + x + x^2)^(3/2), x, 4, (9/64)*(1 + 2*x)*Sqrt[1 + x + x^2] + (1/8)*(1 + 2*x)*(1 + x + x^2)^(3/2) + (27/128)*ArcSinh[(1 + 2*x)/Sqrt[3]]}
{(1 + x + x^2)^(5/2), x, 5, (45/512)*(1 + 2*x)*Sqrt[1 + x + x^2] + (5/64)*(1 + 2*x)*(1 + x + x^2)^(3/2) + (1/12)*(1 + 2*x)*(1 + x + x^2)^(5/2) + 135/1024*ArcSinh[(1 + 2*x)/Sqrt[3]]}
{1/(x^2*Sqrt[1 + x + x^2]), x, 3, -(Sqrt[1 + x + x^2]/x) + (1/2)*ArcTanh[(2 + x)/(2*Sqrt[1 + x + x^2])]}
{1/(x^3*Sqrt[1 + x + x^2]), x, 4, -(Sqrt[1 + x + x^2]/(2*x^2)) + (3*Sqrt[1 + x + x^2])/(4*x) + (1/8)*ArcTanh[(2 + x)/(2*Sqrt[1 + x + x^2])]}
{1/(x^2*(1 + x + x^2)^(3/2)), x, 4, (2*(1 - x))/(3*x*Sqrt[1 + x + x^2]) - (5*Sqrt[1 + x + x^2])/(3*x) + (3/2)*ArcTanh[(2 + x)/(2*Sqrt[1 + x + x^2])]}
{1/(x^3*(1 + x + x^2)^(3/2)), x, 5, (2*(1 - x))/(3*x^2*Sqrt[1 + x + x^2]) - (7*Sqrt[1 + x + x^2])/(6*x^2) + (37*Sqrt[1 + x + x^2])/(12*x) - (3/8)*ArcTanh[(2 + x)/(2*Sqrt[1 + x + x^2])]}
{1/((x + 1)*Sqrt[1 + x + x^2]), x, 2, -ArcTanh[(1 - x)/(2*Sqrt[1 + x + x^2])]}
{1/((x^3 - x)*Sqrt[x^2 + 2*x + 4]), x, 10, (1/2)*ArcTanh[(4 + x)/(2*Sqrt[x^2 + 2*x + 4])] - 1/(2*Sqrt[7])*ArcTanh[(5 + 2*x)/(Sqrt[7]*Sqrt[x^2 + 2*x + 4])] - 1/(2*Sqrt[3])*ArcTanh[Sqrt[x^2 + 2*x + 4]/Sqrt[3]]}


(* ::Subsection::Closed:: *)
(*Problems 73 - 79 (p. 166)*)


{Sqrt[x^2 + 2*x + 4]/(x - 1)^2, x, 6, Sqrt[x^2 + 2*x + 4]/(1 - x) + ArcSinh[(1 + x)/Sqrt[3]] - 2/Sqrt[7]*ArcTanh[(5 + 2*x)/(Sqrt[7]*Sqrt[x^2 + 2*x + 4])]}
{(2*x + 3)/((x^2 + 2*x + 3)^2*Sqrt[x^2 + 2*x + 4]), x, 6, -(((3 - x)*Sqrt[4 + 2*x + x^2])/(4*(3 + 2*x + x^2))) - ArcTan[(1 + x)/(Sqrt[2]*Sqrt[4 + 2*x + x^2])]/(4*Sqrt[2]) + ArcTanh[Sqrt[4 + 2*x + x^2]]}
{(2*x^3 + 3*x^2)/((2*x^2 + x - 3)*Sqrt[x^2 + 2*x - 3]), x, 4, Sqrt[x^2 + 2*x - 3] + Sqrt[x^2 + 2*x - 3]/(2*(1 - x))}
{(x^4 + 1)/((x^2 + x + 1)*Sqrt[x^2 + x + 2]), x, 14, -7/4*Sqrt[x^2 + x + 2] + (1/2)*x*Sqrt[x^2 + x + 2] - (1/8)*ArcSinh[(1 + 2*x)/Sqrt[7]] + 1/Sqrt[3]*ArcTan[(1 + 2*x)/(Sqrt[3]*Sqrt[x^2 + x + 2])] - ArcTanh[Sqrt[x^2 + x + 2]]}
{1/(x^2 + 2*x + 4)^(7/2), x, 3, (1 + x)/(15*(x^2 + 2*x + 4)^(5/2)) + (4*(1 + x))/(135*(x^2 + 2*x + 4)^(3/2)) + (8*(1 + x))/(405*Sqrt[x^2 + 2*x + 4])}
{1/(3*x^2 + 8*x + 1)^(5/2), x, 2, -((4 + 3*x)/(39*(3*x^2 + 8*x + 1)^(3/2))) + (2*(4 + 3*x))/(169*Sqrt[3*x^2 + 8*x + 1])}
{1/(5 + 4*x - 3*x^2)^(5/2), x, 2, -((2 - 3*x)/(57*(5 + 4*x - 3*x^2)^(3/2))) - (2*(2 - 3*x))/(361*Sqrt[5 + 4*x - 3*x^2])}


(* ::Subsection::Closed:: *)
(*Problems 80 - 84 (p. 167)*)


{1/(1 + Sqrt[x^2 + 2*x + 2]), x, 5, 1/(1 + x) - Sqrt[x^2 + 2*x + 2]/(1 + x) + ArcSinh[1 + x]}
{1/(x + Sqrt[1 + x + x^2]), x, -3, -x + Sqrt[1 + x + x^2] - 3/2*ArcSinh[(1 + 2*x)/Sqrt[3]] + 2*Log[x + Sqrt[1 + x + x^2]]}
{x^2/(2*x + 1 + 2*Sqrt[1 + x + x^2]), x, 7, -(x^3/9) - x^4/6 + (1/96)*(1 + 2*x)*Sqrt[1 + x + x^2] - (5/36)*(1 + x + x^2)^(3/2) + (1/6)*x*(1 + x + x^2)^(3/2) + (1/64)*ArcSinh[(1 + 2*x)/Sqrt[3]]}
{(Sqrt[1 + x + x^2] - 3*x)/(Sqrt[1 + x + x^2] - 1), x, 26, x - 3*Sqrt[1 + x + x^2] + (5/2)*ArcSinh[(1 + 2*x)/Sqrt[3]] + 4*ArcTanh[(1 - x)/(2*Sqrt[1 + x + x^2])] - ArcTanh[(2 + x)/(2*Sqrt[1 + x + x^2])] + Log[x] - 4*Log[1 + x]}
{(x + 1)/(Sqrt[x^2 + 2*x + 4] - Sqrt[x^2 + x + 1]), x, 36, -2*Sqrt[x^2 + x + 1] + (1/4)*(1 + 2*x)*Sqrt[x^2 + x + 1] - 2*Sqrt[x^2 + 2*x + 4] + (1/2)*(1 + x)*Sqrt[x^2 + 2*x + 4] + (11/2)*ArcSinh[(1 + x)/Sqrt[3]] + (43/8)*ArcSinh[(1 + 2*x)/Sqrt[3]] - 2*Sqrt[7]*ArcTanh[(1 + 5*x)/(2*Sqrt[7]*Sqrt[x^2 + x + 1])] + 2*Sqrt[7]*ArcTanh[(1 - 2*x)/(Sqrt[7]*Sqrt[x^2 + 2*x + 4])]}


(* ::Subsection::Closed:: *)
(*Problems 85 - 91 (p. 177)*)


{1/(x^3*Sqrt[x - 1]), x, 4, Sqrt[x - 1]/(2*x^2) + (3*Sqrt[x - 1])/(4*x) + (3/4)*ArcTan[Sqrt[x - 1]]}
{1/(x^2*(1 - 3/x)^(4/3)), x, 1, -(1/(1 - 3/x)^(1/3))}
{(3*x - 1)^(4/3)/x^2, x, 6, 12*(3*x - 1)^(1/3) - (3*x - 1)^(4/3)/x + 4*Sqrt[3]*ArcTan[(1 - 2*(3*x - 1)^(1/3))/Sqrt[3]] + 2*Log[x] - 6*Log[1 + (3*x - 1)^(1/3)]}
{(4 - 3*x)^(4/3)*x^2, x, 2, (-(16/63))*(4 - 3*x)^(7/3) + (4/45)*(4 - 3*x)^(10/3) - (1/117)*(4 - 3*x)^(13/3)}
{(1 - 2*x^(1/3))^(3/4)/x, x, 6, 4*(1 - 2*x^(1/3))^(3/4) + 6*ArcTan[(1 - 2*x^(1/3))^(1/4)] - 6*ArcTanh[(1 - 2*x^(1/3))^(1/4)]}
{x/(3 - 2*Sqrt[x])^(3/4), x, 3, (-(27/2))*(3 - 2*Sqrt[x])^(1/4) + (27/10)*(3 - 2*Sqrt[x])^(5/4) - (1/2)*(3 - 2*Sqrt[x])^(9/4) + (1/26)*(3 - 2*Sqrt[x])^(13/4)}
{(2*Sqrt[x] - 1)^(5/4)/x^2, x, 13, -((2*Sqrt[x] - 1)^(5/4)/x) - (5*(2*Sqrt[x] - 1)^(1/4))/(2*Sqrt[x]) - (5*ArcTan[1 - Sqrt[2]*(2*Sqrt[x] - 1)^(1/4)])/(2*Sqrt[2]) + (5*ArcTan[1 + Sqrt[2]*(2*Sqrt[x] - 1)^(1/4)])/(2*Sqrt[2]) - (5*Log[1 - Sqrt[2]*(2*Sqrt[x] - 1)^(1/4) + Sqrt[2*Sqrt[x] - 1]])/(4*Sqrt[2]) + (5*Log[1 + Sqrt[2]*(2*Sqrt[x] - 1)^(1/4) + Sqrt[2*Sqrt[x] - 1]])/(4*Sqrt[2])}


(* ::Subsection::Closed:: *)
(*Problems 92 - 100 (p. 178)*)


{(x^7 + 1)^(1/3)*x^6, x, 1, (3/28)*(x^7 + 1)^(4/3)}
{x^6/(x^7 + 1)^(5/3), x, 1, -(3/(14*(x^7 + 1)^(2/3)))}
{1/(x*(2*x^7 - 27)^(2/3)), x, 5, (-(1/(21*Sqrt[3])))*ArcTan[(3 - 2*(2*x^7 - 27)^(1/3))/(3*Sqrt[3])] - Log[x]/18 + (1/42)*Log[3 + (2*x^7 - 27)^(1/3)]}
{(x^7 + 1)^(2/3)/x^8, x, 6, -((x^7 + 1)^(2/3)/(7*x^7)) + (2*ArcTan[(1 + 2*(x^7 + 1)^(1/3))/Sqrt[3]])/(7*Sqrt[3]) - Log[x]/3 + (1/7)*Log[1 - (x^7 + 1)^(1/3)]}
{(3 + 4*x^4)^(1/4)/x^2, x, 5, -((3 + 4*x^4)^(1/4)/x) - ArcTan[(Sqrt[2]*x)/(3 + 4*x^4)^(1/4)]/Sqrt[2] + ArcTanh[(Sqrt[2]*x)/(3 + 4*x^4)^(1/4)]/Sqrt[2]}
{x^2*(3 + 4*x^4)^(5/4), x, 6, (15/32)*x^3*(3 + 4*x^4)^(1/4) + (1/8)*x^3*(3 + 4*x^4)^(5/4) - (45*ArcTan[(Sqrt[2]*x)/(3 + 4*x^4)^(1/4)])/(128*Sqrt[2]) + (45*ArcTanh[(Sqrt[2]*x)/(3 + 4*x^4)^(1/4)])/(128*Sqrt[2])}
{x^6*(3 + 4*x^4)^(1/4), x, 6, (3/128)*x^3*(3 + 4*x^4)^(1/4) + (1/8)*x^7*(3 + 4*x^4)^(1/4) + (27*ArcTan[(Sqrt[2]*x)/(3 + 4*x^4)^(1/4)])/(512*Sqrt[2]) - (27*ArcTanh[(Sqrt[2]*x)/(3 + 4*x^4)^(1/4)])/(512*Sqrt[2])}
{(x*(1 - x^2))^(1/3), x, 6, (1/2)*x*(x*(1 - x^2))^(1/3) + (1/(2*Sqrt[3]))*ArcTan[(2*x - (x*(1 - x^2))^(1/3))/(Sqrt[3]*(x*(1 - x^2))^(1/3))] + Log[x]/12 - (1/4)*Log[x + (x*(1 - x^2))^(1/3)], (1/2)*x*(x - x^3)^(1/3) - (x^(2/3)*(1 - x^2)^(2/3)*ArcTan[(1 - (2*x^(2/3))/(1 - x^2)^(1/3))/Sqrt[3]])/(2*Sqrt[3]*(x - x^3)^(2/3)) - (x^(2/3)*(1 - x^2)^(2/3)*Log[x^(2/3) + (1 - x^2)^(1/3)])/(4*(x - x^3)^(2/3))}
{Sqrt[x*(1 + x^(1/3))], x, 8, (7/64)*Sqrt[x*(1 + x^(1/3))] - (21*Sqrt[x*(1 + x^(1/3))])/(128*x^(1/3)) - (7/80)*x^(1/3)*Sqrt[x*(1 + x^(1/3))] + (3/40)*x^(2/3)*Sqrt[x*(1 + x^(1/3))] + (3/5)*x*Sqrt[x*(1 + x^(1/3))] + (21/128)*ArcTanh[x^(2/3)/Sqrt[x*(1 + x^(1/3))]], (7/64)*Sqrt[x + x^(4/3)] - (21*Sqrt[x + x^(4/3)])/(128*x^(1/3)) - (7/80)*x^(1/3)*Sqrt[x + x^(4/3)] + (3/40)*x^(2/3)*Sqrt[x + x^(4/3)] + (3/5)*x*Sqrt[x + x^(4/3)] + (21/128)*ArcTanh[x^(2/3)/Sqrt[x + x^(4/3)]]}


(* ::Subsection::Closed:: *)
(*Problems 101 - 112 (p. 193-194)*)


{x^3/((x^4 - 1)*Sqrt[2*x^8 + 1]), x, 3, -1/(4*Sqrt[3])*ArcTanh[(2*x^4 + 1)/(Sqrt[3]*Sqrt[2*x^8 + 1])]}
{x^9*Sqrt[1 + x^5 + x^10], x, 5, (-(1/40))*(1 + 2*x^5)*Sqrt[1 + x^5 + x^10] + (1/15)*(1 + x^5 + x^10)^(3/2) - (3/80)*ArcSinh[(1 + 2*x^5)/Sqrt[3]]}
{1/(x^5*Sqrt[4 + 2*x^2 + x^4]), x, 5, -(Sqrt[4 + 2*x^2 + x^4]/(16*x^4)) + (3*Sqrt[4 + 2*x^2 + x^4])/(64*x^2) + (1/128)*ArcTanh[(4 + x^2)/(2*Sqrt[4 + 2*x^2 + x^4])]}
{(x^2 - 1)/(x*Sqrt[1 + 3*x^2 + x^4]), x, 3, ArcTanh[(1 + x^2)/Sqrt[1 + 3*x^2 + x^4]]}
{(x^4 - 3*x^2)^(3/5)*(2*x^3 - 3*x), x, 1, (5/16)*(x^4 - 3*x^2)^(8/5)}
{(3*x^8 - 2*x^5 - x^2*(3*x^3 - 1)^(2/3))/(3*x^3 - 1)^(3/4), x, 9, (-(4/27))*(3*x^3 - 1)^(1/4) - (4/33)*(3*x^3 - 1)^(11/12) + (4/243)*(3*x^3 - 1)^(9/4)}
{1/((x^3 - 1)*(x^3 + 2)^(1/3)), x, 1, -(ArcTan[(1 + (2*3^(1/3)*x)/(2 + x^3)^(1/3))/Sqrt[3]]/3^(5/6)) - Log[-1 + x^3]/(6*3^(1/3)) + Log[3^(1/3)*x - (2 + x^3)^(1/3)]/(2*3^(1/3))}
{1/((x^4 + 1)*(x^4 + 2)^(1/4)), x, 10, -(ArcTan[1 - (Sqrt[2]*x)/(x^4 + 2)^(1/4)]/(2*Sqrt[2])) + ArcTan[1 + (Sqrt[2]*x)/(x^4 + 2)^(1/4)]/(2*Sqrt[2]) - Log[1 + x^2/Sqrt[x^4 + 2] - (Sqrt[2]*x)/(x^4 + 2)^(1/4)]/(4*Sqrt[2]) + Log[1 + x^2/Sqrt[x^4 + 2] + (Sqrt[2]*x)/(x^4 + 2)^(1/4)]/(4*Sqrt[2])}
{(x^3 - 1)/(x^3 + 2)^(1/3), x, 2, (1/3)*x*(2 + x^3)^(2/3) - (5*ArcTan[(1 + (2*x)/(2 + x^3)^(1/3))/Sqrt[3]])/(3*Sqrt[3]) + (5/6)*Log[-x + (2 + x^3)^(1/3)]}
{(x^4 + 1)^(3/4)/(x^4 + 2)^2, x, 5, (x*(x^4 + 1)^(3/4))/(8*(x^4 + 2)) + (3*ArcTan[x/(2^(1/4)*(x^4 + 1)^(1/4))])/(16*2^(3/4)) + (3*ArcTanh[x/(2^(1/4)*(x^4 + 1)^(1/4))])/(16*2^(3/4))}
{(x^5 - 2)^2/((x^5 + 3)^3*(x^5 + 3)^(1/5)), x, 3, -(5*x*(x^5 - 2))/(33*(x^5 + 3)^(11/5)) + (5*x)/(297*(x^5 + 3)^(6/5)) + (97*x)/(891*(x^5 + 3)^(1/5)), (x*(2 - x^5)^2)/(33*(3 + x^5)^(11/5)) + (10*x*(2 - x^5))/(297*(3 + x^5)^(6/5)) + (100*x)/(891*(3 + x^5)^(1/5))}
{1/((x^3 + 3*x^2 + 3*x)*(x^3 + 3*x^2 + 3*x + 3)^(1/3)), x, 3, -(ArcTan[(1 + (2*3^(1/3)*(1 + x))/(2 + (1 + x)^3)^(1/3))/Sqrt[3]]/3^(5/6)) - Log[1 - (1 + x)^3]/(6*3^(1/3)) + Log[3^(1/3)*(1 + x) - (2 + (1 + x)^3)^(1/3)]/(2*3^(1/3))}


(* ::Subsection::Closed:: *)
(*Problems 113 - 122 (p. 195-196)*)


{(1 - x^2)/((1 + x^2)*Sqrt[1 + x^4]), x, 2, 1/Sqrt[2]*ArcTan[(Sqrt[2]*x)/Sqrt[1 + x^4]]}
{(1 + x^2)/((1 - x^2)*Sqrt[1 + x^4]), x, 2, 1/Sqrt[2]*ArcTanh[(Sqrt[2]*x)/Sqrt[1 + x^4]]}
{(x^2 + 1)/(x*Sqrt[1 + x^4]), x, 6, ArcTanh[(x^2 - 1)/Sqrt[1 + x^4]], ArcSinh[x^2]/2 - (1/2)*ArcTanh[Sqrt[1 + x^4]]}
{(x^2 - 1)/(x*Sqrt[1 + x^4]), x, 6, ArcTanh[(x^2 + 1)/Sqrt[1 + x^4]], ArcSinh[x^2]/2 + (1/2)*ArcTanh[Sqrt[1 + x^4]]}
{(1 + x^2)/((1 - x^2)*Sqrt[1 + x^2 + x^4]), x, 2, (1/Sqrt[3])*ArcTanh[(Sqrt[3]*x)/Sqrt[1 + x^2 + x^4]]}
{(1 - x^2)/((1 + x^2)*Sqrt[1 + x^2 + x^4]), x, 2, ArcTan[x/Sqrt[1 + x^2 + x^4]]}
{(x^4 - 1)/(x^2*Sqrt[x^4 + x^2 + 1]), x, 1, Sqrt[x^4 + x^2 + 1]/x}
{(1 - x^2)/((1 + 2*a*x + x^2)*Sqrt[1 + 2*a*x + 2*b*x^2 + 2*a*x^3 + x^4]), x, 1, (1/(Sqrt[2]*Sqrt[1 - b]))*ArcTan[(a + 2*(a^2 - b + 1)*x + a*x^2)/(Sqrt[2]*Sqrt[1 - b]*Sqrt[1 + 2*a*x + 2*b*x^2 + 2*a*x^3 + x^4])]}
{1/((1 + x^4)*Sqrt[Sqrt[1 + x^4] - x^2]), x, 2, ArcTan[x/Sqrt[Sqrt[1 + x^4] - x^2]]}
{1/((1 + x^(2*n))*((1 + x^(2*n))^(1/n) - x^2)^(1/2)), x, 2, ArcTan[x/Sqrt[(1 + x^(2*n))^(1/n) - x^2]]}


(* ::Section::Closed:: *)
(*Chapter 5 Integration Problems*)


(* ::Subsection::Closed:: *)
(*Problems 1 - 3 (p. 202-203)*)


{Cos[x]^2, x, 2, x/2 + (1/2)*Cos[x]*Sin[x]}
{Cos[x]^3, x, 2, Sin[x] - Sin[x]^3/3}
{Sin[x]^4, x, 3, (3*x)/8 - (3/8)*Cos[x]*Sin[x] - (1/4)*Cos[x]*Sin[x]^3}


(* ::Subsection::Closed:: *)
(*Problems 4 - 7 (p. 208)*)


{Cos[x]^6, x, 4, (5*x)/16 + (5/16)*Cos[x]*Sin[x] + (5/24)*Cos[x]^3*Sin[x] + (1/6)*Cos[x]^5*Sin[x]}
{Sin[x]^8, x, 5, (35*x)/128 - (35/128)*Cos[x]*Sin[x] - (35/192)*Cos[x]*Sin[x]^3 - (7/48)*Cos[x]*Sin[x]^5 - (1/8)*Cos[x]*Sin[x]^7}
{Cos[Pi/4 + x/2]^4, x, 3, (3*x)/8 + Cos[x]/2 - (1/8)*Cos[x]*Sin[x], (3*x)/8 + (3/4)*Cos[Pi/4 + x/2]*Sin[Pi/4 + x/2] + (1/2)*Cos[Pi/4 + x/2]^3*Sin[Pi/4 + x/2]}
{Sin[3*x - Pi/12]^3, x, 2, (-(1/3))*Cos[Pi/12 - 3*x] + (1/9)*Cos[Pi/12 - 3*x]^3}


(* ::Subsection::Closed:: *)
(*Problems 8 - 11 (p. 211)*)


{1/Sin[x]^6, x, 2, -Cot[x] - (2*Cot[x]^3)/3 - Cot[x]^5/5}
{Csc[x]^7, x, 4, (-(5/16))*ArcTanh[Cos[x]] - (5/16)*Cot[x]*Csc[x] - (5/24)*Cot[x]*Csc[x]^3 - (1/6)*Cot[x]*Csc[x]^5}
{1/Cos[x]^12, x, 2, Tan[x] + (5*Tan[x]^3)/3 + 2*Tan[x]^5 + (10*Tan[x]^7)/7 + (5*Tan[x]^9)/9 + Tan[x]^11/11}
{1/Cos[Pi/4 + 3*x]^3, x, 2, (1/6)*ArcTanh[Sin[Pi/4 + 3*x]] + (1/6)*Sec[Pi/4 + 3*x]*Tan[Pi/4 + 3*x]}


(* ::Subsection::Closed:: *)
(*Problems 12 - 14 (p. 213)*)


{Tan[x]^6, x, 4, -x + Tan[x] - Tan[x]^3/3 + Tan[x]^5/5}
{1/Tan[x]^5, x, 3, Cot[x]^2/2 - Cot[x]^4/4 + Log[Sin[x]]}
{Cot[x/3 - 3*Pi/4]^4, x, 3, x + 3*Cot[Pi/4 + x/3] - Cot[Pi/4 + x/3]^3}


(* ::Subsection::Closed:: *)
(*Problems 15 - 20 (p. 219-220)*)


{Sin[x]^4*Cos[x]^6, x, 6, (3*x)/256 + (3/256)*Cos[x]*Sin[x] + (1/128)*Cos[x]^3*Sin[x] + (1/160)*Cos[x]^5*Sin[x] - (3/80)*Cos[x]^7*Sin[x] - (1/10)*Cos[x]^7*Sin[x]^3}
{Sin[x]^7*Cos[x]^6, x, 3, (-(1/7))*Cos[x]^7 + Cos[x]^9/3 - (3*Cos[x]^11)/11 + Cos[x]^13/13}
{Sin[x]^11/Cos[x], x, 4, (5*Cos[x]^2)/2 - (5*Cos[x]^4)/2 + (5*Cos[x]^6)/3 - (5*Cos[x]^8)/8 + Cos[x]^10/10 - Log[Cos[x]]}
{1/(Sin[x]^6*Cos[x]^6), x, 3, -10*Cot[x] - (5*Cot[x]^3)/3 - Cot[x]^5/5 + 10*Tan[x] + (5*Tan[x]^3)/3 + Tan[x]^5/5}
{Sin[x]^2*Cos[x]^2, x, 3, x/8 + (1/8)*Cos[x]*Sin[x] - (1/4)*Cos[x]^3*Sin[x]}
{Sin[x]^4*Cos[x]^4, x, 5, (3*x)/128 + (3/128)*Cos[x]*Sin[x] + (1/64)*Cos[x]^3*Sin[x] - (1/16)*Cos[x]^5*Sin[x] - (1/8)*Cos[x]^5*Sin[x]^3}
{Sin[x]^6*Cos[x]^6, x, 7, (5*x)/1024 + (5*Cos[x]*Sin[x])/1024 + (5*Cos[x]^3*Sin[x])/1536 + (1/384)*Cos[x]^5*Sin[x] - (1/64)*Cos[x]^7*Sin[x] - (1/24)*Cos[x]^7*Sin[x]^3 - (1/12)*Cos[x]^7*Sin[x]^5}
{Sin[x]^8*Cos[x]^8, x, 9, (35*x)/32768 + (35*Cos[x]*Sin[x])/32768 + (35*Cos[x]^3*Sin[x])/49152 + (7*Cos[x]^5*Sin[x])/12288 + (Cos[x]^7*Sin[x])/2048 - (1/256)*Cos[x]^9*Sin[x] - (5/384)*Cos[x]^9*Sin[x]^3 - (1/32)*Cos[x]^9*Sin[x]^5 - (1/16)*Cos[x]^9*Sin[x]^7}
{Sin[x]^(2*m)*Cos[x]^(2*m), x, 1, (Cos[x]^(-1 + 2*m)*(Cos[x]^2)^(1/2 - m)*Hypergeometric2F1[(1/2)*(1 - 2*m), (1/2)*(1 + 2*m), (1/2)*(3 + 2*m), Sin[x]^2]*Sin[x]^(1 + 2*m))/(1 + 2*m)}
{1/(Sin[Pi/4 + 2*x]^3*Cos[Pi/4 + 2*x]), x, 3, (-(1/4))*Cot[Pi/4 + 2*x]^2 + (1/2)*Log[Tan[Pi/4 + 2*x]]}


(* ::Subsection::Closed:: *)
(*Problems 21 - 29 (p. 223)*)


{Tan[x]^2*Sec[x]^2, x, 2, Tan[x]^3/3}
{Cot[x]^3*Csc[x], x, 2, Csc[x] - Csc[x]^3/3}
{Tan[x]*Sec[x]^3, x, 2, Sec[x]^3/3}
{Cot[x]^2*Csc[x]^3, x, 3, (1/8)*ArcTanh[Cos[x]] + (1/8)*Cot[x]*Csc[x] - (1/4)*Cot[x]*Csc[x]^3}
{Cos[x]^3/Sin[x]^7, x, 3, Csc[x]^4/4 - Csc[x]^6/6}
{Tan[x]^5*Sec[x]^(3/2), x, 3, (2/3)*Sec[x]^(3/2) - (4/7)*Sec[x]^(7/2) + (2/11)*Sec[x]^(11/2)}
{Tan[x]^(3/2)*Sec[x]^4, x, 3, (2/5)*Tan[x]^(5/2) + (2/9)*Tan[x]^(9/2)}
{Cot[x]^4*Csc[x]^3, x, 4, (-(1/16))*ArcTanh[Cos[x]] - (1/16)*Cot[x]*Csc[x] + (1/8)*Cot[x]*Csc[x]^3 - (1/6)*Cot[x]^3*Csc[x]^3}
{Tan[Pi/4 + x/2]^2*Sec[Pi/4 + x/2]^3, x, 3, (-(1/4))*ArcTanh[Sin[Pi/4 + x/2]] - (1/4)*Sec[Pi/4 + x/2]*Tan[Pi/4 + x/2] + (1/2)*Sec[Pi/4 + x/2]^3*Tan[Pi/4 + x/2]}


(* ::Subsection::Closed:: *)
(*Problems 30 - 32 (p. 228)*)


{(a*Sec[x]^2 - Sin[2*x])^2*(Cot[x]^3 + 1), x, 8, x/2 + 4*a*x + 2*Cos[x]^2 + Cos[x]^4 + 4*a*Cot[x] - (1/2)*a^2*Cot[x]^2 + (4 - a)*a*Log[Cos[x]] + (4 + a^2)*Log[Sin[x]] + (1/2)*Cos[x]*Sin[x] - Cos[x]^3*Sin[x] + a^2*Tan[x] + (1/3)*a^2*Tan[x]^3, (1/2)*(1 + 8*a)*x + 4*a*Cot[x] - (1/2)*a^2*Cot[x]^2 + 4*(1 + a)*Log[Cos[x]] + (4 + a^2)*Log[Tan[x]] + Cos[x]^4*(1 - Tan[x]) + a^2*Tan[x] + (1/3)*a^2*Tan[x]^3 + (1/2)*Cos[x]^2*(4 + Tan[x])}
{(1 - 1/2*Sin[x])^4*(4 - 3*Cos[x]), x, 15, (227*x)/32 + 10*Cos[x] - 3*Cos[x]^2 - (2*Cos[x]^3)/3 - 3*Sin[x] - (99/32)*Cos[x]*Sin[x] - (3*Sin[x]^3)/2 - (1/16)*Cos[x]*Sin[x]^3 + (3*Sin[x]^4)/8 - (3*Sin[x]^5)/80}
{(3 - 2*Cot[x])^3*(1/2 - 3*Cot[x]), x, 4, -((285*x)/2) + 5*(3 - 2*Cot[x])^2 + (3 - 2*Cot[x])^3 - 42*Cot[x] + 4*Log[Sin[x]]}


(* ::Subsection::Closed:: *)
(*Problems 33 - 36 (p. 229)*)


{Cos[5*x]/Cos[x]^5, x, 4, 16*x - 15*Tan[x] + (5*Tan[x]^3)/3}
{Cos[4*x]/Cos[x], x, 4, ArcTanh[Sin[x]] - (8*Sin[x]^3)/3}
{Cos[4*x]*Cos[x], x, 1, (1/6)*Sin[3*x] + (1/10)*Sin[5*x]}
{Cos[4*x]/Cos[x]^5, x, 4, (35/8)*ArcTanh[Sin[x]] - (29/8)*Sec[x]*Tan[x] + (1/4)*Sec[x]^3*Tan[x]}


(* ::Subsection::Closed:: *)
(*Problems 37 - 39 (p. 233)*)


{Cos[4*x]*Cos[x]^4, x, 6, x/16 + (1/8)*Sin[2*x] + (3/32)*Sin[4*x] + (1/24)*Sin[6*x] + (1/128)*Sin[8*x]}
{Cos[5*x]/Sin[x]^5, x, 4, 6*Csc[x]^2 - Csc[x]^4/4 + 16*Log[Sin[x]]}
{Sin[4*x]/Sin[x]^4, x, 3, -2*Csc[x]^2 - 8*Log[Sin[x]]}


(* ::Subsection::Closed:: *)
(*Problems 40 - 49 (p. 254-255)*)


{Cos[x]/(Sin[x]*(2 + Sin[2*x])), x, 7, -x/(2*Sqrt[3]) + 1/(2*Sqrt[3])*ArcTan[(1 - 2*Cos[x]^2)/(2 + Sqrt[3] + 2*Cos[x]*Sin[x])] + 1/2*Log[Sin[x]] - 1/4*Log[1 + Cos[x]*Sin[x]], -(x/(2*Sqrt[3])) + ArcTan[(1 - 2*Cos[x]^2)/(2 + Sqrt[3] + 2*Cos[x]*Sin[x])]/(2*Sqrt[3]) + (1/2)*Log[Tan[x]] - (1/4)*Log[1 + Tan[x] + Tan[x]^2]}
{Cos[x]^2/(Sin[x]*Cos[3*x]), x, 5, -1/2*Log[Csc[x]^2 - 4], Log[Sin[x]] - (1/2)*Log[1 - 4*Sin[x]^2]}
{Sin[2*x]/(Cos[x]^4 + Sin[x]^4), x, 5, -ArcTan[Cos[2*x]]}
{1/(4 + Sqrt[3]*Cos[x] + Sin[x]), x, 3, x/(2*Sqrt[3]) + (1/Sqrt[3])*ArcTan[(Cos[x] - Sqrt[3]*Sin[x])/(2*(2 + Sqrt[3]) + Sqrt[3]*Cos[x] + Sin[x])], x/(2*Sqrt[3]) + ArcTan[((4 - Sqrt[3])*Cos[x] + (3 - 4*Sqrt[3])*Sin[x])/(2*(5 + 2*Sqrt[3]) - (3 - 4*Sqrt[3])*Cos[x] + (4 - Sqrt[3])*Sin[x])]/Sqrt[3]}
{1/(3 + 4*Cos[x] + 4*Sin[x]), x, 3, -1/Sqrt[23]*ArcTanh[Sqrt[23]*(Cos[x] - Sin[x])/(8 + 3*Cos[x] + 3*Sin[x])], -(Log[4*(5 + Sqrt[23]) + 19*Cos[x] + 4*Sqrt[23]*Cos[x] - 4*Sin[x] - Sqrt[23]*Sin[x]]/(2*Sqrt[23])) + Log[4*(5 - Sqrt[23]) + 19*Cos[x] - 4*Sqrt[23]*Cos[x] - 4*Sin[x] + Sqrt[23]*Sin[x]]/(2*Sqrt[23])}
{1/(4 - 3*Cos[x]^2 + 5*Sin[x]^2), x, 2, x/3 + (1/3)*ArcTan[(2*Cos[x]*Sin[x])/(1 + 2*Sin[x]^2)]}
{1/(4 + Tan[x] + 4*Cot[x]), x, 6, (4*x)/25 - (3/25)*Log[2*Cos[x] + Sin[x]] + 2/(5*(2 + Tan[x]))}
{1/(Sin[x] + 2*Sec[x])^2, x, 4, (8*x)/(15*Sqrt[15]) - (8/(15*Sqrt[15]))*ArcTan[(1 - 2*Cos[x]^2)/(4 + Sqrt[15] + 2*Cos[x]*Sin[x])] + (1 + 4*Tan[x])/(15*(2 + Tan[x] + 2*Tan[x]^2))}
{1/(Cos[x] + 2*Sec[x])^2, x, 3, x/(6*Sqrt[6]) - (1/(6*Sqrt[6]))*ArcTan[(Cos[x]*Sin[x])/(2 + Sqrt[6] + Cos[x]^2)] + Tan[x]/(6*(3 + 2*Tan[x]^2))}
{(5 - Tan[x] - 6*Tan[x]^2)/(1 + 3*Tan[x])^3, x, 4, -((67*x)/250) - (28/125)*Log[Cos[x] + 3*Sin[x]] - 7/(10*(1 + 3*Tan[x])^2) - 29/(50*(1 + 3*Tan[x]))}


(* ::Subsection::Closed:: *)
(*Problems 50 - 56 (p. 260)*)


{Cos[x]^2/Cos[3*x], x, 2, 1/2*ArcTanh[2*Sin[x]]}
{Sin[x]/Cos[2*x], x, 2, ArcTanh[Sqrt[2]*Cos[x]]/Sqrt[2]}
{Sin[x]^2/Cos[2*x], x, 4, -x/2 + 1/4*ArcTanh[2*Cos[x]*Sin[x]]}
{Sin[x]^3/Cos[3*x], x, 4, 1/3*Log[Cos[x]] - 1/24*Log[3 - 4*Cos[x]^2]}
{Cos[x]/Sin[3*x], x, 5, 1/3*Log[Sin[x]] - 1/6*Log[3 - 4*Sin[x]^2]}
{Sin[x]/Sin[4*x], x, 4, -1/4*ArcTanh[Sin[x]] + ArcTanh[Sqrt[2]*Sin[x]]/(2*Sqrt[2])}
{Sin[x]^3/Sin[4*x], x, 4, -1/4*ArcTanh[Sin[x]] + ArcTanh[Sqrt[2]*Sin[x]]/(4*Sqrt[2])}


(* ::Subsection::Closed:: *)
(*Problems 57 - 61 (p. 266)*)


{Sqrt[1 + Sin[2*x]], x, 1, -(Cos[2*x]/Sqrt[1 + Sin[2*x]])}
{Sqrt[1 - Sin[2*x]], x, 1, Cos[2*x]/Sqrt[1 - Sin[2*x]]}
{1/Sqrt[1 + Cos[2*x]], x, 2, ArcTanh[Sin[2*x]/(Sqrt[2]*Sqrt[1 + Cos[2*x]])]/Sqrt[2]}
{1/Sqrt[1 - Cos[2*x]], x, 2, -1/Sqrt[2]*ArcTanh[Sin[2*x]/(Sqrt[2]*Sqrt[1 - Cos[2*x]])]}
{1/(1 - Cos[3*x])^(3/2), x, 3, -(ArcTanh[Sin[3*x]/(Sqrt[2]*Sqrt[1 - Cos[3*x]])]/(6*Sqrt[2])) - Sin[3*x]/(6*(1 - Cos[3*x])^(3/2))}
{(1 - Sin[2*(x/3)])^(5/2), x, 3, (32*Cos[(2*x)/3])/(5*Sqrt[1 - Sin[(2*x)/3]]) + (8/5)*Cos[(2*x)/3]*Sqrt[1 - Sin[(2*x)/3]] + (3/5)*Cos[(2*x)/3]*(1 - Sin[(2*x)/3])^(3/2)}
{(2*(1 + 2*Sin[x])^(1/4) - Cos[x]^2)/(1 + 2*Sin[x])^(3/2)*Cos[x], x, 4, 3/(4*Sqrt[1 + 2*Sin[x]]) - 4/(1 + 2*Sin[x])^(1/4) - (1/2)*Sqrt[1 + 2*Sin[x]] + (1/12)*(1 + 2*Sin[x])^(3/2)}


(* ::Subsection::Closed:: *)
(*Problems 62 - 66 (p. 268)*)


{Sqrt[Tan[x]], x, 11, -(ArcTan[1 - Sqrt[2]*Sqrt[Tan[x]]]/Sqrt[2]) + ArcTan[1 + Sqrt[2]*Sqrt[Tan[x]]]/Sqrt[2] + Log[1 - Sqrt[2]*Sqrt[Tan[x]] + Tan[x]]/(2*Sqrt[2]) - Log[1 + Sqrt[2]*Sqrt[Tan[x]] + Tan[x]]/(2*Sqrt[2])}
{1/Tan[5*x]^(1/3), x, 9, -1/10*Sqrt[3]*ArcTan[(1 - 2*Tan[5*x]^(2/3))/Sqrt[3]] + 3/20*Log[1 + Tan[5*x]^(2/3)] - 1/20*Log[1 + Tan[5*x]^2], (-(1/10))*Sqrt[3]*ArcTan[(1 - 2*Tan[5*x]^(2/3))/Sqrt[3]] + (1/10)*Log[1 + Tan[5*x]^(2/3)] - (1/20)*Log[1 - Tan[5*x]^(2/3) + Tan[5*x]^(4/3)]}
{1/(4 + 3*Tan[2*x])^(3/2), x, 6, -((9*ArcTan[(1 - 3*Tan[2*x])/(Sqrt[2]*Sqrt[4 + 3*Tan[2*x]])])/(250*Sqrt[2])) + (13*ArcTanh[(3 + Tan[2*x])/(Sqrt[2]*Sqrt[4 + 3*Tan[2*x]])])/(250*Sqrt[2]) - 3/(25*Sqrt[4 + 3*Tan[2*x]])}
{(3*Tan[x] - Sqrt[4 - 3*Tan[x]])/(Cos[x]^2*(4 - 3*Tan[x])^(3/2)), x, 4, (1/3)*Log[4 - 3*Tan[x]] + 8/(3*Sqrt[4 - 3*Tan[x]]) + (2/3)*Sqrt[4 - 3*Tan[x]]}
{Tan[x]/(Sqrt[Tan[x]] - 1)^2, x, -19, -(x/2) + ArcTan[(1 - Tan[x])/(Sqrt[2]*Sqrt[Tan[x]])]/Sqrt[2] + ArcTanh[(1 + Tan[x])/(Sqrt[2]*Sqrt[Tan[x]])]/Sqrt[2] + (1/2)*Log[Cos[x]] + Log[1 - Sqrt[Tan[x]]] + 1/(1 - Sqrt[Tan[x]])}


(* ::Subsection::Closed:: *)
(*Problems 67 - 75 (p. 272-273)*)


{Sin[x]/Sqrt[Sin[2*x]], x, 1, (-(1/2))*ArcSin[Cos[x] - Sin[x]] - (1/2)*Log[Cos[x] + Sin[x] + Sqrt[Sin[2*x]]]}
{Cos[x]/Sqrt[Sin[2*x]], x, 1, (-(1/2))*ArcSin[Cos[x] - Sin[x]] + (1/2)*Log[Cos[x] + Sin[x] + Sqrt[Sin[2*x]]]}
{Sqrt[Sin[2*x]]*Sin[x], x, 2, (-(1/4))*ArcSin[Cos[x] - Sin[x]] + (1/4)*Log[Cos[x] + Sin[x] + Sqrt[Sin[2*x]]] - (1/2)*Cos[x]*Sqrt[Sin[2*x]]}
{(Cos[x] - Sin[x])*Sqrt[Sin[2*x]], x, 6, (-(1/2))*Log[Cos[x] + Sin[x] + Sqrt[Sin[2*x]]] + (1/2)*Cos[x]*Sqrt[Sin[2*x]] + (1/2)*Sin[x]*Sqrt[Sin[2*x]]}
{Sin[x]^7/Sin[2*x]^(7/2), x, 4, -1/16*ArcSin[Cos[x] - Sin[x]] + 1/16*Log[Cos[x] + Sin[x] + Sqrt[Sin[2*x]]] + Sin[x]^5/(5*Sin[2*x]^(5/2)) - Sin[x]/(4*Sqrt[Sin[2*x]])}
{Cos[x]^7/Sin[2*x]^(7/2), x, 4, -1/16*ArcSin[Cos[x] - Sin[x]] - 1/16*Log[Cos[x] + Sin[x] + Sqrt[Sin[2*x]]] - Cos[x]^5/(5*Sin[2*x]^(5/2)) + Cos[x]/(4*Sqrt[Sin[2*x]])}
{Sin[2*x]^(3/2)/Sin[x]^5, x, 1, (-(1/5))*Csc[x]^5*Sin[2*x]^(5/2)}
{1/(Cos[x]^3*Sqrt[Sin[2*x]]), x, 2, (4/5)*Sec[x]*Sqrt[Sin[2*x]] + (1/5)*Sec[x]^3*Sqrt[Sin[2*x]]}
{1/(Sin[x]*Sin[2*x]^(3/2)), x, 3, -((2*Cos[x])/(3*Sin[2*x]^(3/2))) + (4*Sin[x])/(3*Sqrt[Sin[2*x]])}
{(Cos[2*x] - 3*Tan[x])*(Cos[x]^3/((Sin[x]^2 - Sin[2*x])*Sin[2*x]^(5/2))), x, 6, (33/32)*ArcTanh[Sqrt[Sin[2*x]]/(2*Cos[x])] - (9*Cos[x])/(16*Sqrt[Sin[2*x]]) - (5*Cos[x]*Cot[x])/(24*Sqrt[Sin[2*x]]) + (Cos[x]*Cot[x]^2)/(20*Sqrt[Sin[2*x]]), Cos[x]^5/(5*Sin[2*x]^(5/2)) - (5*Cos[x]^4*Sin[x])/(6*Sin[2*x]^(5/2)) - (9*Cos[x]^3*Sin[x]^2)/(4*Sin[2*x]^(5/2)) + (33*ArcTanh[Sqrt[Tan[x]]/Sqrt[2]]*Sin[x]^5)/(4*Sqrt[2]*Sin[2*x]^(5/2)*Tan[x]^(5/2))}


(* ::Subsection::Closed:: *)
(*Problems 76 - 82 (p. 276)*)


{Sqrt[Sin[x]/Cos[x]^5], x, 5, (2/3)*Cos[x]*Sin[x]*Sqrt[Sec[x]^4*Tan[x]], (2*Sec[x]^2*Tan[x]^2)/(3*Sqrt[Tan[x] + 2*Tan[x]^3 + Tan[x]^5])}
{Sqrt[Sin[x]^5/Cos[x]], x, 13, 3/(4*Sqrt[2])*ArcTan[(1 - Cot[x])*Csc[x]^2*Sqrt[Sin[x]^4*Tan[x]]/Sqrt[2]] + 3/(4*Sqrt[2])*Log[Cos[x] + Sin[x] - Sqrt[2]*Cot[x]*Csc[x]*Sqrt[Sin[x]^4*Tan[x]]] - 1/2*Cot[x]*Sqrt[Sin[x]^4*Tan[x]], (-(1/2))*Cot[x]*Sqrt[Sin[x]^4*Tan[x]] - (3*ArcTan[1 - Sqrt[2]*Sqrt[Tan[x]]]*Sec[x]^2*Sqrt[Sin[x]^4*Tan[x]])/(4*Sqrt[2]*Tan[x]^(5/2)) + (3*ArcTan[1 + Sqrt[2]*Sqrt[Tan[x]]]*Sec[x]^2*Sqrt[Sin[x]^4*Tan[x]])/(4*Sqrt[2]*Tan[x]^(5/2)) + (3*Log[1 - Sqrt[2]*Sqrt[Tan[x]] + Tan[x]]*Sec[x]^2*Sqrt[Sin[x]^4*Tan[x]])/(8*Sqrt[2]*Tan[x]^(5/2)) - (3*Log[1 + Sqrt[2]*Sqrt[Tan[x]] + Tan[x]]*Sec[x]^2*Sqrt[Sin[x]^4*Tan[x]])/(8*Sqrt[2]*Tan[x]^(5/2))}
{(Sin[x]^2/Cos[x]^14)^(1/3), x, 5, (3/5)*Cos[x]^3*Sin[x]*(Sec[x]^12*Tan[x]^2)^(1/3) + (3/11)*Cos[x]*Sin[x]^3*(Sec[x]^12*Tan[x]^2)^(1/3)}
{1/(Sin[x]^13*Cos[x]^11)^(1/4), x, 4, -((4*Cos[x]^5*Sin[x])/(9*(Cos[x]^11*Sin[x]^13)^(1/4))) - (8*Cos[x]^3*Sin[x]^3)/(Cos[x]^11*Sin[x]^13)^(1/4) + (4*Cos[x]*Sin[x]^5)/(7*(Cos[x]^11*Sin[x]^13)^(1/4))}
{(Cos[2*x] - Sqrt[Sin[2*x]])/Sqrt[Sin[x]*Cos[x]^3], x, If[$VersionNumber<11, -28, -27], -Sqrt[2]*Log[Cos[x] + Sin[x] - Sqrt[2]*Sec[x]*Sqrt[Cos[x]^3*Sin[x]]] - ArcSin[Cos[x] - Sin[x]]*Cos[x]*Sqrt[Sin[2*x]]/Sqrt[Cos[x]^3*Sin[x]] - ArcTanh[Sin[x]]*Cos[x]*Sqrt[Sin[2*x]]/Sqrt[Cos[x]^3*Sin[x]] - Sin[2*x]/Sqrt[Cos[x]^3*Sin[x]]}
{(Sqrt[Sin[x]^3*Cos[x]] - 2*Sin[2*x])/(Sqrt[Tan[x]] - Sqrt[Sin[x]*Cos[x]^3]), x, 66, -2*Sqrt[2]*ArcCoth[(Cos[x]*(Cos[x] + Sin[x]))/(Sqrt[2]*Sqrt[Cos[x]^3*Sin[x]])] + 2^(1/4)*ArcCoth[(Cos[x]*(Sqrt[2]*Cos[x] + Sin[x]))/(2^(3/4)*Sqrt[Cos[x]^3*Sin[x]])] - 2^(1/4)*ArcCoth[(Sqrt[2] + Tan[x])/(2^(3/4)*Sqrt[Tan[x]])] - 2*Sqrt[2]*ArcTan[(Cos[x]*(Cos[x] - Sin[x]))/(Sqrt[2]*Sqrt[Cos[x]^3*Sin[x]])] + 2^(1/4)*ArcTan[(Cos[x]*(Sqrt[2]*Cos[x] - Sin[x]))/(2^(3/4)*Sqrt[Cos[x]^3*Sin[x]])] - 2^(1/4)*ArcTan[(Sqrt[2] - Tan[x])/(2^(3/4)*Sqrt[Tan[x]])] + 4*Csc[x]*Sec[x]*Sqrt[Cos[x]^3*Sin[x]] + (1/4)*Csc[x]^2*Log[1 + Cos[x]^2]*Sec[x]^2*Sqrt[Cos[x]^3*Sin[x]]*Sqrt[Cos[x]*Sin[x]^3] + (1/2)*Csc[x]^2*Log[Sin[x]]*Sec[x]^2*Sqrt[Cos[x]^3*Sin[x]]*Sqrt[Cos[x]*Sin[x]^3] + 4/Sqrt[Tan[x]] - (1/4)*Csc[x]^2*Log[1 + Cos[x]^2]*Sqrt[Cos[x]*Sin[x]^3]*Sqrt[Tan[x]] + (1/2)*Csc[x]^2*Log[Sin[x]]*Sqrt[Cos[x]*Sin[x]^3]*Sqrt[Tan[x]], (-2^(1/4))*ArcTan[1 - 2^(1/4)*Sqrt[Tan[x]]] + 2^(1/4)*ArcTan[1 + 2^(1/4)*Sqrt[Tan[x]]] + Log[Sqrt[2] - 2^(3/4)*Sqrt[Tan[x]] + Tan[x]]/2^(3/4) - Log[Sqrt[2] + 2^(3/4)*Sqrt[Tan[x]] + Tan[x]]/2^(3/4) + 4*Csc[x]*Sec[x]*Sqrt[Cos[x]^3*Sin[x]] - (1/2)*Csc[x]^2*Log[Sec[x]^2]*Sec[x]^2*Sqrt[Cos[x]^3*Sin[x]]*Sqrt[Cos[x]*Sin[x]^3] + Csc[x]^2*Log[Sqrt[Tan[x]]]*Sec[x]^2*Sqrt[Cos[x]^3*Sin[x]]*Sqrt[Cos[x]*Sin[x]^3] + (1/4)*Csc[x]^2*Log[2 + Tan[x]^2]*Sec[x]^2*Sqrt[Cos[x]^3*Sin[x]]*Sqrt[Cos[x]*Sin[x]^3] + (Log[Tan[x]]*Sec[x]^2*Sqrt[Cos[x]*Sin[x]^3])/(2*Tan[x]^(3/2)) - (Log[2 + Tan[x]^2]*Sec[x]^2*Sqrt[Cos[x]*Sin[x]^3])/(4*Tan[x]^(3/2)) + 4/Sqrt[Tan[x]] + (2^(1/4)*ArcTan[1 - 2^(1/4)*Sqrt[Tan[x]]]*Sec[x]^2*Sqrt[Cos[x]^3*Sin[x]])/Sqrt[Tan[x]] - (2^(1/4)*ArcTan[1 + 2^(1/4)*Sqrt[Tan[x]]]*Sec[x]^2*Sqrt[Cos[x]^3*Sin[x]])/Sqrt[Tan[x]] - (2*Sqrt[2]*ArcTan[1 - Sqrt[2]*Sqrt[Tan[x]]]*Sec[x]^2*Sqrt[Cos[x]^3*Sin[x]])/Sqrt[Tan[x]] + (2*Sqrt[2]*ArcTan[1 + Sqrt[2]*Sqrt[Tan[x]]]*Sec[x]^2*Sqrt[Cos[x]^3*Sin[x]])/Sqrt[Tan[x]] + (Sqrt[2]*Log[1 - Sqrt[2]*Sqrt[Tan[x]] + Tan[x]]*Sec[x]^2*Sqrt[Cos[x]^3*Sin[x]])/Sqrt[Tan[x]] - (Sqrt[2]*Log[1 + Sqrt[2]*Sqrt[Tan[x]] + Tan[x]]*Sec[x]^2*Sqrt[Cos[x]^3*Sin[x]])/Sqrt[Tan[x]] - (Log[Sqrt[2] - 2^(3/4)*Sqrt[Tan[x]] + Tan[x]]*Sec[x]^2*Sqrt[Cos[x]^3*Sin[x]])/(2^(3/4)*Sqrt[Tan[x]]) + (Log[Sqrt[2] + 2^(3/4)*Sqrt[Tan[x]] + Tan[x]]*Sec[x]^2*Sqrt[Cos[x]^3*Sin[x]])/(2^(3/4)*Sqrt[Tan[x]])}
{((Sin[x]/Cos[x]^7)^(1/3) - 3*Tan[x])/(Sin[x]*Cos[x]^5)^(2/3), x, 13, -((9*Sin[x]^4)/(10*(Cos[x]^5*Sin[x])^(2/3))) - (9/4)*Sec[x]^8*(Cos[x]^5*Sin[x])^(4/3) + (3/2)*(Cos[x]^5*Sin[x])^(1/3)*(Sec[x]^6*Tan[x])^(1/3) + (3/4)*(Cos[x]^5*Sin[x])^(1/3)*Tan[x]^2*(Sec[x]^6*Tan[x])^(1/3) + (3/14)*(Cos[x]^5*Sin[x])^(1/3)*Tan[x]^4*(Sec[x]^6*Tan[x])^(1/3), -((9*Cos[x]^2*Sin[x]^2)/(4*(Cos[x]^5*Sin[x])^(2/3))) - (9*Sin[x]^4)/(10*(Cos[x]^5*Sin[x])^(2/3)) + (3*Cos[x]^5*Sin[x]*(Sec[x]^6*Tan[x])^(1/3))/(2*(Cos[x]^5*Sin[x])^(2/3)) + (3*Cos[x]^3*Sin[x]^3*(Sec[x]^6*Tan[x])^(1/3))/(4*(Cos[x]^5*Sin[x])^(2/3)) + (3*Cos[x]*Sin[x]^5*(Sec[x]^6*Tan[x])^(1/3))/(14*(Cos[x]^5*Sin[x])^(2/3))}


(* ::Subsection::Closed:: *)
(*Problems 83 - 92 (p. 288-289)*)


{(2*Cos[x]^2 + 1)^(5/2)*Sin[x], x, 5, -((5*ArcSinh[Sqrt[2]*Cos[x]])/(16*Sqrt[2])) - (5/16)*Cos[x]*Sqrt[1 + 2*Cos[x]^2] - (5/24)*Cos[x]*(1 + 2*Cos[x]^2)^(3/2) - (1/6)*Cos[x]*(1 + 2*Cos[x]^2)^(5/2), -((5*ArcSinh[Sqrt[2]*Cos[x]])/(16*Sqrt[2])) - (5/16)*Cos[x]*Sqrt[2 + Cos[2*x]] - (5/24)*Cos[x]*(2 + Cos[2*x])^(3/2) - (1/6)*Cos[x]*(2 + Cos[2*x])^(5/2)}
{(5*Cos[x]^2 + Sin[x]^2)^(5/2)*Cos[x], x, 5, (625/32)*ArcSin[(2*Sin[x])/Sqrt[5]] + (125/16)*Sin[x]*Sqrt[5 - 4*Sin[x]^2] + (25/24)*Sin[x]*(5 - 4*Sin[x]^2)^(3/2) + (1/6)*Sin[x]*(5 - 4*Sin[x]^2)^(5/2)}
{(-Cos[x]^2 - 5*Sin[x]^2)^(3/2)*Cos[x], x, 5, (3/16)*ArcTan[(2*Sin[x])/Sqrt[-1 - 4*Sin[x]^2]] - (3/8)*Sin[x]*Sqrt[-1 - 4*Sin[x]^2] + (1/4)*Sin[x]*(-1 - 4*Sin[x]^2)^(3/2)}
{Sin[x]/(5*Cos[x]^2 - 2*Sin[x]^2)^(7/2), x, 4, Cos[x]/(10*(-2 + 7*Cos[x]^2)^(5/2)) - Cos[x]/(15*(-2 + 7*Cos[x]^2)^(3/2)) + Cos[x]/(15*Sqrt[-2 + 7*Cos[x]^2])}
{Cos[2*x]*(Cos[x]/(2 - 5*Sin[x]^2)^(3/2)), x, 3, (2*ArcSin[Sqrt[5/2]*Sin[x]])/(5*Sqrt[5]) + Sin[x]/(10*Sqrt[2 - 5*Sin[x]^2])}
{Sin[5*x]/(5*Cos[x]^2 + 9*Sin[x]^2)^(5/2), x, 4, (-(1/2))*ArcSin[(2*Cos[x])/3] - (55*Cos[x])/(27*(9 - 4*Cos[x]^2)^(3/2)) + (295*Cos[x])/(243*Sqrt[9 - 4*Cos[x]^2])}
{Cos[x]*Cos[2*x]*Sin[3*x]/(4*Sin[x]^2 - 5)^(5/2), x, 4, -(1/(4*(-5 + 4*Sin[x]^2)^(3/2))) - 5/(8*Sqrt[-5 + 4*Sin[x]^2]) + (1/8)*Sqrt[-5 + 4*Sin[x]^2]}
{(Sin[x]*Cos[2*x] - 2*(Sin[x] - 1)*Cos[x]^3)/(Sin[x]^2*Sqrt[Sin[x]^2 - 5]), x, 18, 2*ArcTan[Cos[x]/Sqrt[Sin[x]^2 - 5]] - (1/Sqrt[5])*ArcTan[(Sqrt[5]*Cos[x])/Sqrt[Sin[x]^2 - 5]] - (2/Sqrt[5])*ArcTan[Sqrt[Sin[x]^2 - 5]/Sqrt[5]] - 2*ArcTanh[Sin[x]/Sqrt[Sin[x]^2 - 5]] + (2*Sqrt[Sin[x]^2 - 5])/(5*Sin[x]) + 2*Sqrt[Sin[x]^2 - 5], 2*ArcTan[Cos[x]/Sqrt[-4 - Cos[x]^2]] - ArcTan[(Sqrt[5]*Cos[x])/Sqrt[-4 - Cos[x]^2]]/Sqrt[5] - (2*ArcTan[Sqrt[-4 - Cos[x]^2]/Sqrt[5]])/Sqrt[5] - 2*ArcTanh[Sin[x]/Sqrt[-5 + Sin[x]^2]] + 2*Sqrt[-4 - Cos[x]^2] + (2/5)*Csc[x]*Sqrt[-5 + Sin[x]^2]}
{Cos[3*x]/(Sqrt[3*Cos[x]^2 - Sin[x]^2] - Sqrt[8*Cos[x]^2 - 1]), x, 27, (5/(4*Sqrt[2]))*ArcSin[2*Sqrt[2/7]*Sin[x]] + (3/4)*ArcSin[(2*Sin[x])/Sqrt[3]] - (3/4)*ArcTan[Sin[x]/Sqrt[4*Cos[x]^2 - 1]] - (3/4)*ArcTan[Sin[x]/Sqrt[8*Cos[x]^2 - 1]] - (1/2)*Sin[x]*Sqrt[4*Cos[x]^2 - 1] - (1/2)*Sin[x]*Sqrt[8*Cos[x]^2 - 1], (5*ArcSin[2*Sqrt[2/7]*Sin[x]])/(4*Sqrt[2]) + (3/4)*ArcSin[(2*Sin[x])/Sqrt[3]] - (3/4)*ArcTan[Sin[x]/Sqrt[7 - 8*Sin[x]^2]] - (3/4)*ArcTan[Sin[x]/Sqrt[3 - 4*Sin[x]^2]] - (1/2)*Sin[x]*Sqrt[7 - 8*Sin[x]^2] - (1/2)*Sin[x]*Sqrt[3 - 4*Sin[x]^2]}
{(2 - 3*Sin[x]^2)^(3/5)*Sin[4*x], x, 5, (5/36)*(2 - 3*Sin[x]^2)^(8/5) - (20/117)*(2 - 3*Sin[x]^2)^(13/5)}


(* ::Subsection::Closed:: *)
(*Problems 93 - 97 (p. 293)*)


{Sqrt[Cos[2*x]]*Cos[x], x, 3, ArcSin[Sqrt[2]*Sin[x]]/(2*Sqrt[2]) + (1/2)*Sin[x]*Sqrt[Cos[2*x]]}
{Cos[2*x]^(3/2)*Sin[x], x, 5, (-(3/(8*Sqrt[2])))*ArcTanh[(Sqrt[2]*Cos[x])/Sqrt[Cos[2*x]]] + (3/8)*Cos[x]*Sqrt[Cos[2*x]] - (1/4)*Cos[x]*Cos[2*x]^(3/2)}
{Sin[x]/Cos[2*x]^(5/2), x, 1, -(Cos[3*x]/(3*Cos[2*x]^(3/2)))}
{Cos[2*x]^(3/2)/Cos[x]^3, x, 6, 2*Sqrt[2]*ArcSin[Sqrt[2]*Sin[x]] - (5/2)*ArcTan[Sin[x]/Sqrt[Cos[2*x]]] - (1/2)*Sec[x]*Tan[x]*Sqrt[Cos[2*x]]}
{(3*Sin[x]^3 - Cos[x]*Sin[4*x])/(Csc[x]^2*Cos[2*x]^(7/2)), x, 11, -(ArcTanh[(Sqrt[2]*Cos[x])/Sqrt[Cos[2*x]]]/Sqrt[2]) - (11*Cos[x])/(20*Cos[2*x]^(3/2)) - (2*Cos[x]^3)/(3*Cos[2*x]^(3/2)) + (63*Cos[x])/(20*Sqrt[Cos[2*x]]) + (3*Cos[x]*Sin[x]^2)/(10*Cos[2*x]^(5/2)), -(ArcTanh[(Sqrt[2]*Cos[x])/Sqrt[Cos[2*x]]]/Sqrt[2]) - (2*Cos[x]^3)/(3*Cos[2*x]^(3/2)) + (13*Cos[x])/(5*Sqrt[Cos[2*x]]) - (4*Cos[x]*Sin[x]^2)/(5*Cos[2*x]^(3/2)) + (3*Cos[x]*Sin[x]^4)/(5*Cos[2*x]^(5/2))}


(* ::Subsection::Closed:: *)
(*Problems 98 - 103 (p. 297)*)


{(4 - 5*Sec[x]^2)^(3/2), x, 7, 8*ArcTan[(2*Tan[x])/Sqrt[-1 - 5*Tan[x]^2]] - (7/2)*Sqrt[5]*ArcTan[(Sqrt[5]*Tan[x])/Sqrt[-1 - 5*Tan[x]^2]] - (5/2)*Tan[x]*Sqrt[-1 - 5*Tan[x]^2]}
{1/(4 - 5*Sec[x]^2)^(3/2), x, 4, (1/8)*ArcTan[(2*Tan[x])/Sqrt[-1 - 5*Tan[x]^2]] - (5*Tan[x])/(4*Sqrt[-1 - 5*Tan[x]^2])}
{(Sin[x] - 2*Cot[x]^2)/(1 + 5*Tan[x]^2)^(3/2), x, 10, -1/4*ArcTanh[(2*Tan[x])/Sqrt[1 + 5*Tan[x]^2]] - Cos[x]/(4*Sqrt[1 + 5*Tan[x]^2]) - (5*Cot[x])/(2*Sqrt[1 + 5*Tan[x]^2]) - 1/8*Cos[x]*Sqrt[1 + 5*Tan[x]^2] + 9/2*Cot[x]*Sqrt[1 + 5*Tan[x]^2], (-(1/4))*ArcTanh[(2*Tan[x])/Sqrt[1 + 5*Tan[x]^2]] + Cos[x]/(4*Sqrt[-4 + 5*Sec[x]^2]) - (5*Sec[x])/(8*Sqrt[-4 + 5*Sec[x]^2]) - (5*Cot[x])/(2*Sqrt[1 + 5*Tan[x]^2]) + (9/2)*Cot[x]*Sqrt[1 + 5*Tan[x]^2]}
{(Cos[2*x] - 3)/(Cos[x]^4*Sqrt[4 - Cot[x]^2]), x, 5, (-(2/3))*Sqrt[4 - Cot[x]^2]*Tan[x] - (1/3)*Sqrt[4 - Cot[x]^2]*Tan[x]^3}
{(3 + Sin[x]^2)*Tan[x]^3/((Cos[x]^2 - 2)*(5 - 4*Sec[x]^2)^(3/2)), x, 16, -(ArcTanh[Sqrt[5 - 4*Sec[x]^2]/Sqrt[3]]/(6*Sqrt[3])) - ArcTanh[Sqrt[5 - 4*Sec[x]^2]/Sqrt[5]]/(5*Sqrt[5]) - 2/(15*Sqrt[5 - 4*Sec[x]^2])}
{(Sec[x]^2 - 3*Tan[x]*Sqrt[4*Sec[x]^2 + 5*Tan[x]^2])/(Sin[x]^2*(4*Sec[x]^2 + 5*Tan[x]^2)^(3/2)), x, 10, (-(3/4))*Log[Tan[x]] + (3/8)*Log[4 + 9*Tan[x]^2] - Cot[x]/(4*Sqrt[4 + 9*Tan[x]^2]) - (7*Tan[x])/(8*Sqrt[4 + 9*Tan[x]^2])}


(* ::Subsection::Closed:: *)
(*Problems 104 - 110 (p. 303)*)


{(1 + 5*Tan[x]^2)^(5/2)*Tan[x], x, 7, -32*ArcTan[(1/2)*Sqrt[1 + 5*Tan[x]^2]] + 16*Sqrt[1 + 5*Tan[x]^2] - (4/3)*(1 + 5*Tan[x]^2)^(3/2) + (1/5)*(1 + 5*Tan[x]^2)^(5/2)}
{Tan[x]/(1 + 5*Tan[x]^2)^(5/2), x, 6, (1/32)*ArcTan[(1/2)*Sqrt[1 + 5*Tan[x]^2]] - 1/(12*(1 + 5*Tan[x]^2)^(3/2)) + 1/(16*Sqrt[1 + 5*Tan[x]^2])}
{Tan[x]/(a^3 + b^3*Tan[x]^2)^(1/3), x, 6, (Sqrt[3]*ArcTan[(1 + (2*(a^3 + b^3*Tan[x]^2)^(1/3))/(a^3 - b^3)^(1/3))/Sqrt[3]])/(2*(a^3 - b^3)^(1/3)) + Log[Cos[x]]/(2*(a^3 - b^3)^(1/3)) + (3*Log[(a^3 - b^3)^(1/3) - (a^3 + b^3*Tan[x]^2)^(1/3)])/(4*(a^3 - b^3)^(1/3))}
{(1 - 7*Tan[x]^2)^(2/3)*Tan[x], x, 7, 2*Sqrt[3]*ArcTan[(1 + (1 - 7*Tan[x]^2)^(1/3))/Sqrt[3]] + 2*Log[Cos[x]] + 3*Log[2 - (1 - 7*Tan[x]^2)^(1/3)] + (3/4)*(1 - 7*Tan[x]^2)^(2/3)}
{Cot[x]/(a^4 + b^4*Csc[x]^2)^(1/4), x, 6, -ArcTan[(a^4 + b^4*Csc[x]^2)^(1/4)/a]/a + ArcTanh[(a^4 + b^4*Csc[x]^2)^(1/4)/a]/a}
{Cot[x]/(a^4 - b^4*Csc[x]^2)^(1/4), x, 6, -ArcTan[(a^4 - b^4*Csc[x]^2)^(1/4)/a]/a + ArcTanh[(a^4 - b^4*Csc[x]^2)^(1/4)/a]/a}
{(3*Tan[x]^2 + Sin[x]^2*(1 - 3*Sec[x]^2)^(1/3))/(Cos[x]^2*(1 - 3*Sec[x]^2)^(5/6)*(1 - Sqrt[1 - 3*Sec[x]^2]))*Tan[x], x, 29, Sqrt[3]*ArcTan[(1 + 2*(1 - 3*Sec[x]^2)^(1/6))/Sqrt[3]] + (1/4)*Log[Sec[x]^2] - (3/2)*Log[1 - (1 - 3*Sec[x]^2)^(1/6)] + (1/3)*Log[1 - Sqrt[1 - 3*Sec[x]^2]] - (1 - 3*Sec[x]^2)^(1/6) - (1/4)*(1 - 3*Sec[x]^2)^(2/3) + 1/(2*(1 - Sqrt[1 - 3*Sec[x]^2])), Sqrt[3]*ArcTan[(1 + 2*(1 - 3*Sec[x]^2)^(1/6))/Sqrt[3]] + (1/2)*ArcTanh[Sqrt[1 - 3*Sec[x]^2]] + Cos[x]^2/6 + (1/3)*Log[1 - Sqrt[-((3 - Cos[x]^2)*Sec[x]^2)]] - (3/2)*Log[1 - (1 - 3*Sec[x]^2)^(1/6)] + (1/2)*Log[1 - Sqrt[1 - 3*Sec[x]^2]] - (1 - 3*Sec[x]^2)^(1/6) + (1/6)*Cos[x]^2*Sqrt[1 - 3*Sec[x]^2] - (1/4)*(1 - 3*Sec[x]^2)^(2/3)}
{(2*Tan[x]^2 - Cos[2*x])/(Cos[x]^2*(Tan[x]*Tan[2*x])^(3/2)), x, -22, 2*ArcTanh[Tan[x]/Sqrt[Tan[x]*Tan[2*x]]] - (11/(4*Sqrt[2]))*ArcTanh[(Sqrt[2]*Tan[x])/Sqrt[Tan[x]*Tan[2*x]]] + Tan[x]/(2*(Tan[x]*Tan[2*x])^(3/2)) + (2*Tan[x]^3)/(3*(Tan[x]*Tan[2*x])^(3/2)) + (3*Tan[x])/(4*Sqrt[Tan[x]*Tan[2*x]])}


(* ::Subsection::Closed:: *)
(*Problems 111 - 113 (p. 305-306)*)


{Tan[x]/(a^3 - b^3*Cos[x]^n)^(4/3), x, 7, (-(Sqrt[3]/(a^4*n)))*ArcTan[(a + 2*(a^3 - b^3*Cos[x]^n)^(1/3))/(Sqrt[3]*a)] - 3/(a^3*n*(a^3 - b^3*Cos[x]^n)^(1/3)) + Log[Cos[x]]/(2*a^4) - (3*Log[a - (a^3 - b^3*Cos[x]^n)^(1/3)])/(2*a^4*n)}
{(1 + 2*Cos[x]^9)^(5/6)*Tan[x], x, 14, ArcTan[(1 - (1 + 2*Cos[x]^9)^(1/3))/(Sqrt[3]*(1 + 2*Cos[x]^9)^(1/6))]/(3*Sqrt[3]) + (1/3)*ArcTanh[(1 + 2*Cos[x]^9)^(1/6)] - (1/9)*ArcTanh[Sqrt[1 + 2*Cos[x]^9]] - (2/15)*(1 + 2*Cos[x]^9)^(5/6), ArcTan[(1 - 2*(1 + 2*Cos[x]^9)^(1/6))/Sqrt[3]]/(3*Sqrt[3]) - ArcTan[(1 + 2*(1 + 2*Cos[x]^9)^(1/6))/Sqrt[3]]/(3*Sqrt[3]) + (2/9)*ArcTanh[(1 + 2*Cos[x]^9)^(1/6)] - (2/15)*(1 + 2*Cos[x]^9)^(5/6) - (1/18)*Log[1 - (1 + 2*Cos[x]^9)^(1/6) + (1 + 2*Cos[x]^9)^(1/3)] + (1/18)*Log[1 + (1 + 2*Cos[x]^9)^(1/6) + (1 + 2*Cos[x]^9)^(1/3)]}
{Sin[x]^9*Cot[x]/(2 - 5*Sin[x]^3)^(4/3), x, 4, 4/(125*(2 - 5*Sin[x]^3)^(1/3)) + (2/125)*(2 - 5*Sin[x]^3)^(2/3) - (1/625)*(2 - 5*Sin[x]^3)^(5/3)}


(* ::Subsection::Closed:: *)
(*Problems 114 - 120 (p. 308-309)*)


{((1 + (1 - 8*Tan[x]^2)^(1/3))/(Cos[x]^2*(1 - 8*Tan[x]^2)^(2/3)))*Tan[x], x, 2, (-(3/32))*(1 + (1 - 8*Tan[x]^2)^(1/3))^2}
{((1 + (1 - 8*Tan[x]^2)^(1/3))/(Cos[x]^2*(1 - 8*Tan[x]^2)^(2/3)))*Cot[x], x, 15, -Log[Tan[x]] + (3/2)*Log[1 - (1 - 8*Tan[x]^2)^(1/3)], (-(1/2))*Log[1 - Sec[x]^2] + (3/2)*Log[1 - (9 - 8*Sec[x]^2)^(1/3)]}
{(5*Cos[x]^2 - Sqrt[5*Sin[x]^2 - 1])/((5*Sin[x]^2 - 1)^(1/4)*(2 + Sqrt[5*Sin[x]^2 - 1]))*Tan[x], x, 14, (-(3/Sqrt[2]))*ArcTan[(-1 + 5*Sin[x]^2)^(1/4)/Sqrt[2]] - (1/(2*Sqrt[2]))*ArcTanh[(-1 + 5*Sin[x]^2)^(1/4)/Sqrt[2]] + 2*(-1 + 5*Sin[x]^2)^(1/4) - (-1 + 5*Sin[x]^2)^(1/4)/(2*(2 + Sqrt[-1 + 5*Sin[x]^2])), ArcTan[(4 - 5*Cos[x]^2)^(1/4)/Sqrt[2]]/Sqrt[2] - 2*Sqrt[2]*ArcTan[(4 - 5*Cos[x]^2)^(1/4)/Sqrt[2]] - ArcTanh[(4 - 5*Cos[x]^2)^(1/4)/Sqrt[2]]/(2*Sqrt[2]) + 2*(4 - 5*Cos[x]^2)^(1/4) - (4 - 5*Cos[x]^2)^(1/4)/(2*(2 + Sqrt[4 - 5*Cos[x]^2]))}
{Cos[x]^4*Cos[2*x]^(2/3)*Tan[x], x, 4, (-(3/40))*Cos[2*x]^(5/3) - (3/64)*Cos[2*x]^(8/3)}
{Sin[x]^6*(Tan[x]/Cos[2*x]^(3/4)), x, -14, ArcTan[(1 - Sqrt[Cos[2*x]])/(Sqrt[2]*Cos[2*x]^(1/4))]/Sqrt[2] - ArcTanh[(1 + Sqrt[Cos[2*x]])/(Sqrt[2]*Cos[2*x]^(1/4))]/Sqrt[2] + (7/4)*Cos[2*x]^(1/4) - (1/5)*Cos[2*x]^(5/4) + (1/36)*Cos[2*x]^(9/4)}
{Sqrt[Tan[x]*Tan[2*x]], x, 3, -ArcTanh[Tan[x]/Sqrt[Tan[x]*Tan[2*x]]], -ArcTanh[Tan[2*x]/Sqrt[-1 + Sec[2*x]]]}
{Sqrt[Cot[2*x]/Cot[x]], x, 6, -(ArcSin[Tan[x]]/Sqrt[2]) + ArcTan[(Sqrt[2]*Tan[x])/Sqrt[1 - Tan[x]^2]]}


(* ::Section::Closed:: *)
(*Chapter 6 Integration Problems*)


(* ::Subsection::Closed:: *)
(*Problems 1 - 5 (p. 314)*)


{1/(x^5*(5 + x^2)), x, 3, -(1/(20*x^4)) + 1/(50*x^2) + Log[x]/125 - (1/250)*Log[5 + x^2]}
{1/(x^6*(5 + x^2)), x, 4, -(1/(25*x^5)) + 1/(75*x^3) - 1/(125*x) - ArcTan[x/Sqrt[5]]/(125*Sqrt[5])}
{1/(x*(x^2 - 4)^4), x, 3, 1/(24*(4 - x^2)^3) + 1/(64*(4 - x^2)^2) + 1/(128*(4 - x^2)) + Log[x]/256 - (1/512)*Log[4 - x^2]}
{1/(x*(x^2 - 2)^(5/2)), x, 5, -(1/(6*(x^2 - 2)^(3/2))) + 1/(4*Sqrt[x^2 - 2]) + ArcTan[Sqrt[x^2 - 2]/Sqrt[2]]/(4*Sqrt[2])}
{(x^2 - 10)^(5/2)/x, x, 6, 100*Sqrt[x^2 - 10] - (10/3)*(x^2 - 10)^(3/2) + (1/5)*(x^2 - 10)^(5/2) - 100*Sqrt[10]*ArcTan[Sqrt[x^2 - 10]/Sqrt[10]]}


(* ::Subsection::Closed:: *)
(*Problems 6 - 21 (p. 327-328)*)


{x^(2*n + 1), x, 1, x^(2*(n + 1))/(2*(n + 1))}
{x^7/(x^2 - 5)^3, x, 3, x^2/2 - 125/(4*(5 - x^2)^2) + 75/(2*(5 - x^2)) + (15/2)*Log[5 - x^2]}
{(3*x^5 - 4*x^3)/(x^2 - 1)^5, x, 4, 1/(8*(1 - x^2)^4) + 1/(3*(1 - x^2)^3) - 3/(4*(1 - x^2)^2)}
{(1 + x^2)^(9/14)*x^3, x, 3, -7/23*(1 + x^2)^(23/14) + 7/37*(1 + x^2)^(37/14)}
{x^5/(x^2 - 4)^(13/6), x, 3, -(48/(7*(x^2 - 4)^(7/6))) - 24/(x^2 - 4)^(1/6) + (3/5)*(x^2 - 4)^(5/6)}
{1/(1+2*x^2)^(5/2), x, 2, x/(3*(1 + 2*x^2)^(3/2)) + (2*x)/(3*Sqrt[1 + 2*x^2])}
{1/(x^2 - 2*x - 1)^(5/2), x, 2, (1 - x)/(6*(x^2 - 2*x - 1)^(3/2)) - (1 - x)/(6*Sqrt[x^2 - 2*x - 1])}
{1/(x^4*(x^2 - 8)^(3/2)), x, 3, 1/(24*x^3*Sqrt[x^2 - 8]) + 1/(48*x*Sqrt[x^2 - 8]) - x/(192*Sqrt[x^2 - 8])}
{(x^2 + 5)^2/(x^4*x^(1/3)), x, 2, -(15/(2*x^(10/3))) - 15/(2*x^(4/3)) + (3*x^(2/3))/2}
{1/(x^7*(1 + x^2)^3), x, 3, -(1/(6*x^6)) + 3/(4*x^4) - 3/x^2 - 1/(4*(1 + x^2)^2) - 2/(1 + x^2) - 10*Log[x] + 5*Log[1 + x^2]}
{((2 + x^2)/x^2)^(7/9)/(2 + x^2)^(3/2), x, 3, -((9*(1 + 2/x^2)^(7/9)*x)/(10*Sqrt[2 + x^2]))}
{x^4/(Sqrt[10] - x^2)^(9/2), x, 2, x^5/(7*Sqrt[10]*(Sqrt[10] - x^2)^(7/2)) + x^5/(175*(Sqrt[10] - x^2)^(5/2)), x^5/(5*Sqrt[10]*(Sqrt[10] - x^2)^(7/2)) - x^7/(175*(Sqrt[10] - x^2)^(7/2))}
{x^2/(3 - x^2)^(3/2), x, 2, x/Sqrt[3 - x^2] - ArcSin[x/Sqrt[3]]}
{(25 - x^2)^(3/2)/x^4, x, 3, Sqrt[25 - x^2]/x - (25 - x^2)^(3/2)/(3*x^3) + ArcSin[x/5]}
{1/(1 - 2*x^2)^(7/2), x, 3, x/(5*(1 - 2*x^2)^(5/2)) + (4*x)/(15*(1 - 2*x^2)^(3/2)) + (8*x)/(15*Sqrt[1 - 2*x^2])}
{1/(-x^2 + 6*x - 7)^(5/2), x, 2, -((3 - x)/(6*(-x^2 + 6*x - 7)^(3/2))) - (3 - x)/(6*Sqrt[-x^2 + 6*x - 7])}


(* ::Subsection::Closed:: *)
(*Problems 22 - 25 (p. 329)*)


{(-2*x^2 - 2*x + 1)^3, x, 2, x - 3*x^2 + 2*x^3 + 4*x^4 - (12*x^5)/5 - 4*x^6 - (8*x^7)/7}
{(x^2 - x - 1)^2*(5*x - 1), x, 2, -x + (3*x^2)/2 + (11*x^3)/3 - (3*x^4)/4 - (11*x^5)/5 + (5*x^6)/6}
{(3*x + 1)/(2*x^2 - 8*x + 1)^(5/2), x, 2, (1 - 2*x)/(6*(2*x^2 - 8*x + 1)^(3/2)) - (2*(2 - x))/(21*Sqrt[2*x^2 - 8*x + 1])}
{(8*x^3 - 8*x - 1)/(1 + 2*x - 4*x^2)^(5/2), x, 2, -((4*(1 + x))/(15*(1 + 2*x - 4*x^2)^(3/2))) - (7 + 122*x)/(75*Sqrt[1 + 2*x - 4*x^2])}


(* ::Section::Closed:: *)
(*Chapter 7 Integration Problems*)


(* ::Subsection::Closed:: *)
(*Problems 1 - 4 (p. 334)*)


{x^2*Cos[x]^5, x, 9, (16/15)*x*Cos[x] + (8/45)*x*Cos[x]^3 + (2/25)*x*Cos[x]^5 - (298*Sin[x])/225 + (8/15)*x^2*Sin[x] + (4/15)*x^2*Cos[x]^2*Sin[x] + (1/5)*x^2*Cos[x]^4*Sin[x] + (76*Sin[x]^3)/675 - (2*Sin[x]^5)/125}
{x^3*Sin[x]^3, x, 8, (40/9)*x*Cos[x] - (2/3)*x^3*Cos[x] - (40*Sin[x])/9 + 2*x^2*Sin[x] + (2/9)*x*Cos[x]*Sin[x]^2 - (1/3)*x^3*Cos[x]*Sin[x]^2 - (2*Sin[x]^3)/27 + (1/3)*x^2*Sin[x]^3}
{x^2*Sin[x]^6, x, 13, -((245*x)/1152) + (5*x^3)/48 + (245*Cos[x]*Sin[x])/1152 - (5/16)*x^2*Cos[x]*Sin[x] + (5/16)*x*Sin[x]^2 + (65*Cos[x]*Sin[x]^3)/1728 - (5/24)*x^2*Cos[x]*Sin[x]^3 + (5/48)*x*Sin[x]^4 + (1/108)*Cos[x]*Sin[x]^5 - (1/6)*x^2*Cos[x]*Sin[x]^5 + (1/18)*x*Sin[x]^6}
{x^2*Sin[x]^2*Cos[x], x, 4, (4/9)*x*Cos[x] - (4*Sin[x])/9 + (2/9)*x*Cos[x]*Sin[x]^2 - (2*Sin[x]^3)/27 + (1/3)*x^2*Sin[x]^3}


(* ::Subsection::Closed:: *)
(*Problems 5 - 9 (p. 342-343) *)


{x*Cos[x]^4/Sin[x]^2, x, 6, -((3*x^2)/4) - Cos[x]^2/4 - x*Cot[x] + Log[Sin[x]] - (1/2)*x*Cos[x]*Sin[x]}
{x*Sin[x]^3/Cos[x]^4, x, 5, (5/6)*ArcTanh[Sin[x]] - x*Sec[x] + (1/3)*x*Sec[x]^3 - (1/6)*Sec[x]*Tan[x]}
{x*Sin[x]/Cos[x]^3, x, 3, (1/2)*x*Sec[x]^2 - Tan[x]/2}
{x*Sin[x]^3/Cos[x], x, 8, x/4 + (I*x^2)/2 - x*Log[1 + E^(2*I*x)] + (1/2)*I*PolyLog[2, -E^(2*I*x)] - (1/4)*Cos[x]*Sin[x] - (1/2)*x*Sin[x]^2}
{x*Sin[x]^3/Cos[x]^3, x, 7, x/2 - (I*x^2)/2 + x*Log[1 + E^(2*I*x)] - (1/2)*I*PolyLog[2, -E^(2*I*x)] - Tan[x]/2 + (1/2)*x*Tan[x]^2}


(* ::Subsection::Closed:: *)
(*Problems 10 - 11 (p. 344)*)


{(2*x+Sin[2*x])/(x*Sin[x]+Cos[x])^2, x, 2, 2/(1 + Cot[x]/x)}
{(x/(x*Cos[x]-Sin[x]))^2, x, 3, -Cot[x] + (x*Csc[x])/(x*Cos[x] - Sin[x])}


(* ::Section::Closed:: *)
(*Chapter 8 Integration Problems*)


(* ::Subsection::Closed:: *)
(*Problems 1 - 5 (p. 346)*)


{a^(m*x)*b^(n*x), x, 2, (a^(m*x)*b^(n*x))/(m*Log[a] + n*Log[b])}
{(a^x - b^x)^2/(a^x*b^x), x, 9, -2*x + (a^x/b^x - b^x/a^x)/(Log[a] - Log[b]), -2*x + a^x/(b^x*(Log[a] - Log[b])) - b^x/(a^x*(Log[a] - Log[b]))}
{(E^x - E^(-x))^1, x, 3, E^x + E^(-x)}
{(E^x - E^(-x))^2, x, 4, -(1/2)/E^(2*x) + E^(2*x)/2 - 2*x}
{(E^x - E^(-x))^3, x, 3, 1/(3*E^(3*x)) - 3/E^x - 3*E^x + E^(3*x)/3}
{(E^x - E^(-x))^4, x, 4, -(1/4)/E^(4*x) + 2/E^(2*x) - 2*E^(2*x) + E^(4*x)/4 + 6*x}
{(E^x - E^(-x))^n, x, 4, -(((-E^(-x) + E^x)^n*(1 - E^(2*x))*Hypergeometric2F1[1, (2 + n)/2, 1 - n/2, E^(2*x)])/n), -(((-E^(-x) + E^x)^n*Hypergeometric2F1[-n, -(n/2), 1 - n/2, E^(2*x)])/((1 - E^(2*x))^n*n))}
{(a^(-4*x) - a^(2*x))^3, x, 4, 3*x - 1/(a^(12*x)*(12*Log[a])) + 1/(a^(6*x)*(2*Log[a])) - a^(6*x)/(6*Log[a])}
{(a^(k*x) + a^(l*x))^1, x, 3, a^(k*x)/(k*Log[a]) + a^(l*x)/(l*Log[a])}
{(a^(k*x) + a^(l*x))^2, x, 6, a^(2*k*x)/(2*k*Log[a]) + a^(2*l*x)/(2*l*Log[a]) + (2*a^((k + l)*x))/((k + l)*Log[a])}
{(a^(k*x) + a^(l*x))^3, x, 7, a^(3*k*x)/(3*k*Log[a]) + a^(3*l*x)/(3*l*Log[a]) + (3*a^((2*k + l)*x))/((2*k + l)*Log[a]) + (3*a^((k + 2*l)*x))/((k + 2*l)*Log[a])}
{(a^(k*x) + a^(l*x))^4, x, 8, a^(4*k*x)/(4*k*Log[a]) + a^(4*l*x)/(4*l*Log[a]) + (3*a^(2*(k + l)*x))/((k + l)*Log[a]) + (4*a^((3*k + l)*x))/((3*k + l)*Log[a]) + (4*a^((k + 3*l)*x))/((k + 3*l)*Log[a])}
{(a^(k*x) + a^(l*x))^n, x, 2, (((1 + a^((k - l)*x))*(a^(k*x) + a^(l*x))^n)/(l*n*Log[a]))*Hypergeometric2F1[1, 1 + (k*n)/(k - l), 1 + (l*n)/(k - l), -a^((k - l)*x)], ((a^(k*x) + a^(l*x))^n*Hypergeometric2F1[-n, -((k*n)/(k - l)), 1 - (k*n)/(k - l), -a^(-((k - l)*x))])/((1 + a^(-((k - l)*x)))^n*(k*n*Log[a]))}
{(a^(k*x) - a^(l*x))^1, x, 3, a^(k*x)/(k*Log[a]) - a^(l*x)/(l*Log[a])}
{(a^(k*x) - a^(l*x))^2, x, 6, a^(2*k*x)/(2*k*Log[a]) + a^(2*l*x)/(2*l*Log[a]) - (2*a^((k + l)*x))/((k + l)*Log[a])}
{(a^(k*x) - a^(l*x))^3, x, 7, a^(3*k*x)/(3*k*Log[a]) - a^(3*l*x)/(3*l*Log[a]) - (3*a^((2*k + l)*x))/((2*k + l)*Log[a]) + (3*a^((k + 2*l)*x))/((k + 2*l)*Log[a])}
{(a^(k*x) - a^(l*x))^4, x, 8, a^(4*k*x)/(4*k*Log[a]) + a^(4*l*x)/(4*l*Log[a]) + (3*a^(2*(k + l)*x))/((k + l)*Log[a]) - (4*a^((3*k + l)*x))/((3*k + l)*Log[a]) - (4*a^((k + 3*l)*x))/((k + 3*l)*Log[a])}
{(a^(k*x) - a^(l*x))^n, x, 2, (((1 - a^((k - l)*x))*(a^(k*x) - a^(l*x))^n)/(l*n*Log[a]))*Hypergeometric2F1[1, 1 + (k*n)/(k - l), 1 + (l*n)/(k - l), a^((k - l)*x)], ((a^(k*x) - a^(l*x))^n*Hypergeometric2F1[-n, -((k*n)/(k - l)), 1 - (k*n)/(k - l), a^(-((k - l)*x))])/((1 - a^(-((k - l)*x)))^n*(k*n*Log[a]))}


(* ::Subsection::Closed:: *)
(*Problems 6 - 9 (p. 346)*)


{(1 + a^(m*x))^1, x, 2, x + a^(m*x)/(m*Log[a])}
{(1 + a^(m*x))^2, x, 3, x + (2*a^(m*x))/(m*Log[a]) + a^(2*m*x)/(2*m*Log[a])}
{(1 + a^(m*x))^3, x, 3, x + (3*a^(m*x))/(m*Log[a]) + (3*a^(2*m*x))/(2*m*Log[a]) + a^(3*m*x)/(3*m*Log[a])}
{(1 + a^(m*x))^4, x, 3, x + (4*a^(m*x))/(m*Log[a]) + (3*a^(2*m*x))/(m*Log[a]) + (4*a^(3*m*x))/(3*m*Log[a]) + a^(4*m*x)/(4*m*Log[a])}
{(1 + a^(m*x))^n, x, 2, -(((1 + a^(m*x))^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, 1 + a^(m*x)])/(m*(1 + n)*Log[a]))}
{(1 - a^(m*x))^1, x, 2, x - a^(m*x)/(m*Log[a])}
{(1 - a^(m*x))^2, x, 3, x - (2*a^(m*x))/(m*Log[a]) + a^(2*m*x)/(2*m*Log[a])}
{(1 - a^(m*x))^3, x, 3, x - (3*a^(m*x))/(m*Log[a]) + (3*a^(2*m*x))/(2*m*Log[a]) - a^(3*m*x)/(3*m*Log[a])}
{(1 - a^(m*x))^4, x, 3, x - (4*a^(m*x))/(m*Log[a]) + (3*a^(2*m*x))/(m*Log[a]) - (4*a^(3*m*x))/(3*m*Log[a]) + a^(4*m*x)/(4*m*Log[a])}
{(1 - a^(m*x))^n, x, 2, -(((1 - a^(m*x))^(1 + n)*Hypergeometric2F1[1, 1 + n, 2 + n, 1 - a^(m*x)])/(m*(1 + n)*Log[a]))}
{1/(a*E^(n*x) + b), x, 4, x/b - Log[b + a*E^(n*x)]/(b*n)}
{E^x/(a*E^(3*x) + b), x, 7, -(ArcTan[(b^(1/3) - 2*a^(1/3)*E^x)/(Sqrt[3]*b^(1/3))]/(Sqrt[3]*a^(1/3)*b^(2/3))) + Log[b^(1/3) + a^(1/3)*E^x]/(2*a^(1/3)*b^(2/3)) - Log[b + a*E^(3*x)]/(6*a^(1/3)*b^(2/3)), -(ArcTan[(b^(1/3) - 2*a^(1/3)*E^x)/(Sqrt[3]*b^(1/3))]/(Sqrt[3]*a^(1/3)*b^(2/3))) + Log[b^(1/3) + a^(1/3)*E^x]/(3*a^(1/3)*b^(2/3)) - Log[b^(2/3) - a^(1/3)*b^(1/3)*E^x + a^(2/3)*E^(2*x)]/(6*a^(1/3)*b^(2/3))}
{(E^x - 1)/(E^x + 1), x, 3, -x + 2*Log[1 + E^x]}


(* ::Subsection::Closed:: *)
(*Problems 10 - 16 (p. 347)*)


{E^(4*x)/(3*E^(4*x) - 2*E^(2*x) + 1), x, 5, -(ArcTan[(1 - 3*E^(2*x))/Sqrt[2]]/(6*Sqrt[2])) + (1/12)*Log[1 - 2*E^(2*x) + 3*E^(4*x)]}
{(E^(5*x) + E^x)/(E^(3*x) - E^(2*x) + E^x - 1), x, 6, E^x + E^(2*x)/2 - ArcTan[E^x] + Log[1 - E^x] - (1/2)*Log[1 + E^(2*x)]}
{(a + b*E^(n*x))^(r/s)*E^(n*x), x, 2, s*(a + b*E^(n*x))^((s + r)/s)/(b*n*(s + r))}
{(1 - 2*E^(x/3))^(1/4), x, 6, 12*(1 - 2*E^(x/3))^(1/4) - 6*ArcTan[(1 - 2*E^(x/3))^(1/4)] - 6*ArcTanh[(1 - 2*E^(x/3))^(1/4)]}
{(a + b*E^(n*x))^(r/s), x, 2, -(((a + b*E^(n*x))^((r + s)/s)*s*Hypergeometric2F1[1, (r + s)/s, 2 + r/s, 1 + (b*E^(n*x))/a])/(a*n*(r + s)))}
{E^x/Sqrt[E^(2*x) + a^2], x, 3, ArcTanh[E^x/Sqrt[a^2 + E^(2*x)]]}
{E^x/Sqrt[E^(2*x) - a^2], x, 3, ArcTanh[E^x/Sqrt[-a^2 + E^(2*x)]]}
{E^((3/4)*x)/((E^((3/4)*x) - 2)*Sqrt[E^((3/2)*x) + E^((3/4)*x) - 2]), x, 3, (2/3)*ArcTanh[(2 - 5*E^((3*x)/4))/(4*Sqrt[-2 + E^((3*x)/4) + E^((3*x)/2)])]}


(* ::Subsection::Closed:: *)
(*Problems 17 - 18 (p. 348)*)


{(E^(7*x) - 3)^(2/3)/E^(2*x), x, 4, ((1/6)*(-3 + E^(7*x))^(5/3)*Hypergeometric2F1[1, 29/21, 5/7, E^(7*x)/3])/E^(2*x), -((3^(2/3)*(-3 + E^(7*x))^(2/3)*Hypergeometric2F1[-(2/3), -(2/7), 5/7, E^(7*x)/3])/(E^(2*x)*(2*(3 - E^(7*x))^(2/3))))}
{E^(2*x)/(3 - E^(x/2))^(3/4), x, 3, -216*(3 - E^(x/2))^(1/4) + (216/5)*(3 - E^(x/2))^(5/4) - 8*(3 - E^(x/2))^(9/4) + (8/13)*(3 - E^(x/2))^(13/4)}


(* ::Subsection::Closed:: *)
(*Problems 19 - 24 (p. 351)*)


{x^3/E^(x/2), x, 4, -96/E^(x/2) - (48*x)/E^(x/2) - (12*x^2)/E^(x/2) - (2*x^3)/E^(x/2)}
{1/(x^3*E^(x/2)), x, 3, -(1/(E^(x/2)*(2*x^2))) + 1/(E^(x/2)*(4*x)) + (1/8)*ExpIntegralEi[-(x/2)]}
{x^2*a^(3*x), x, 3, (2*a^(3*x))/(27*Log[a]^3) - (2*a^(3*x)*x)/(9*Log[a]^2) + (a^(3*x)*x^2)/(3*Log[a])}
{x*(x^2 + 1)*E^x^2, x, 5, (1/2)*E^x^2*x^2}
{x/(E^x + E^(-x))^2, x, 6, x/2 - x/(2*(1 + E^(2*x))) - (1/4)*Log[1 + E^(2*x)]}
{(1 - x - x^2)/Sqrt[1 - x^2]*E^x, x, 1, E^x*Sqrt[1 - x^2]}


(* ::Subsection::Closed:: *)
(*Problems 25 - 32 (p. 353)*)


{Cos[2*x]/E^(3*x), x, 1, ((-(3/13))*Cos[2*x])/E^(3*x) + ((2/13)*Sin[2*x])/E^(3*x)}
{(Sin[x/2] + Cos[x/2])/(E^x)^(1/3), x, 6, -((30*Cos[x/2])/(13*(E^x)^(1/3))) + (6*Sin[x/2])/(13*(E^x)^(1/3))}
{Cos[3*x/2]/(3^(3*x))^(1/4), x, 2, -((4*Cos[(3*x)/2]*Log[3])/(3*(3^(3*x))^(1/4)*(4 + Log[3]^2))) + (8*Sin[(3*x)/2])/(3*(3^(3*x))^(1/4)*(4 + Log[3]^2))}
{E^(m*x)*Cos[x]^2, x, 2, (2*E^(m*x))/(m*(4 + m^2)) + (E^(m*x)*m*Cos[x]^2)/(4 + m^2) + (2*E^(m*x)*Cos[x]*Sin[x])/(4 + m^2)}
{E^(m*x)*Sin[x]^3, x, 2, -((6*E^(m*x)*Cos[x])/(9 + 10*m^2 + m^4)) + (6*E^(m*x)*m*Sin[x])/(9 + 10*m^2 + m^4) - (3*E^(m*x)*Cos[x]*Sin[x]^2)/(9 + m^2) + (E^(m*x)*m*Sin[x]^3)/(9 + m^2)}
{Cos[x/3]^3/Sqrt[E^x], x, 3, -((48*Cos[x/3])/(65*Sqrt[E^x])) - (2*Cos[x/3]^3)/(5*Sqrt[E^x]) + (32*Sin[x/3])/(65*Sqrt[E^x]) + (4*Cos[x/3]^2*Sin[x/3])/(5*Sqrt[E^x])}
{E^(2*x)*Sin[x]^2*Cos[x]^2, x, 4, E^(2*x)/16 - (1/80)*E^(2*x)*Cos[4*x] - (1/40)*E^(2*x)*Sin[4*x]}
{E^(3*x)*Sin[3*(x/2)]^2*Cos[3*(x/2)]^2, x, 4, E^(3*x)/24 - (1/120)*E^(3*x)*Cos[6*x] - (1/60)*E^(3*x)*Sin[6*x]}


(* ::Subsection::Closed:: *)
(*Problems 33 - 36 (p. 355)*)


{E^(m*x)*Tan[x]^2, x, 5, -(E^(m*x)/m) + 4*E^((2*I + m)*x)*Hypergeometric2F1[2, 1 - (I*m)/2, 2 - (I*m)/2, -E^(2*I*x)]/(2*I + m), -(E^(m*x)/m) + (4*E^(m*x)*Hypergeometric2F1[1, -((I*m)/2), 1 - (I*m)/2, -E^(2*I*x)])/m - (4*E^(m*x)*Hypergeometric2F1[2, -((I*m)/2), 1 - (I*m)/2, -E^(2*I*x)])/m}
{E^(m*x)/Sin[x]^2, x, 1, -((4*E^((2*I + m)*x)*Hypergeometric2F1[2, 1 - (I*m)/2, 2 - (I*m)/2, E^(2*I*x)])/(2*I + m))}
{E^(m*x)/Cos[x]^3, x, 2, ((8*E^((3*I + m)*x))/(3*I + m))*Hypergeometric2F1[3, (3 - I*m)/2, (5 - I*m)/2, -E^(2*I*x)], (-E^((I + m)*x))*(I - m)*Hypergeometric2F1[1, (1/2)*(1 - I*m), (1/2)*(3 - I*m), -E^(2*I*x)] - (1/2)*E^(m*x)*m*Sec[x] + (1/2)*E^(m*x)*Sec[x]*Tan[x]}
{E^x/(1 + Cos[x]), x, 2, (1 - I)*E^((1 + I)*x)*Hypergeometric2F1[2, 1 - I, 2 - I, -E^(I*x)]}
{E^x/(1 - Cos[x]), x, 2, -(1 - I)*E^((1 + I)*x)*Hypergeometric2F1[2, 1 - I, 2 - I, E^(I*x)]}
{E^x/(1 + Sin[x]), x, 2, (-1 + I)*E^((1 - I)*x)*Hypergeometric2F1[1 + I, 2, 2 + I, -I/E^(I*x)]}
{E^x/(1 - Sin[x]), x, 2, (1 + I)*E^((1 + I)*x)*Hypergeometric2F1[1 - I, 2, 2 - I, (-I)*E^(I*x)]}


(* ::Subsection::Closed:: *)
(*Problems 37 - 44 (p. 356)*)


{E^x*((1 - Sin[x])/(1 - Cos[x])), x, 1, -E^x*Sin[x]/(1 - Cos[x])}
{E^x*((1 + Sin[x])/(1 - Cos[x])), x, 7, (E^x*Sin[x])/(1 - Cos[x]) - 2*(1 - I)*E^((1 + I)*x)*Hypergeometric2F1[2, 1 - I, 2 - I, E^(I*x)], 2*I*E^x - 4*I*E^x*Hypergeometric2F1[-I, 1, 1 - I, E^(I*x)] - (E^x*Sin[x])/(1 - Cos[x])}
{E^x*((1 + Sin[x])/(1 + Cos[x])), x, 1, E^x*Sin[x]/(1 + Cos[x])}
{E^x*((1 - Sin[x])/(1 + Cos[x])), x, 7, -((E^x*Sin[x])/(1 + Cos[x])) + 2*(1 - I)*E^((1 + I)*x)*Hypergeometric2F1[2, 1 - I, 2 - I, -E^(I*x)], 2*I*E^x - 4*I*E^x*Hypergeometric2F1[-I, 1, 1 - I, -E^(I*x)] + (E^x*Sin[x])/(1 + Cos[x])}

{E^x*((1 - Cos[x])/(1 - Sin[x])), x, 7, -((E^x*Cos[x])/(1 - Sin[x])) + 2*(1 + I)*E^((1 + I)*x)*Hypergeometric2F1[2, 1 - I, 2 - I, (-I)*E^(I*x)], 2*I*E^x - 4*I*E^x*Hypergeometric2F1[-I, 1, 1 - I, (-I)*E^(I*x)] + (E^x*Cos[x])/(1 - Sin[x])}
{E^x*((1 + Cos[x])/(1 - Sin[x])), x, 1, E^x*Cos[x]/(1 - Sin[x])}
{E^x*((1 + Cos[x])/(1 + Sin[x])), x, 7, (E^x*Cos[x])/(1 + Sin[x]) - 2*(1 + I)*E^((1 + I)*x)*Hypergeometric2F1[2, 1 - I, 2 - I, I*E^(I*x)], -2*I*E^x + 4*I*E^x*Hypergeometric2F1[I, 1, 1 + I, -I/E^(I*x)] - (E^x*Cos[x])/(1 + Sin[x])}
{E^x*((1 - Cos[x])/(1 + Sin[x])), x, 1, -E^x*Cos[x]/(1 + Sin[x])}


(* ::Subsection::Closed:: *)
(*Problems 45 - 49 (p. 357-358)*)


{x*E^x*Cos[x], x, 4, (1/2)*E^x*x*Cos[x] - (1/2)*E^x*Sin[x] + (1/2)*E^x*x*Sin[x]}
{x^2*E^x*Sin[x], x, 11, (-(1/2))*E^x*Cos[x] + E^x*x*Cos[x] - (1/2)*E^x*x^2*Cos[x] - (1/2)*E^x*Sin[x] + (1/2)*E^x*x^2*Sin[x]}
{x^2*(Sin[x]/E^(3*x)), x, 11, ((-(13/250))*Cos[x])/E^(3*x) - ((3/25)*x*Cos[x])/E^(3*x) - ((1/10)*x^2*Cos[x])/E^(3*x) - ((9/250)*Sin[x])/E^(3*x) - ((4/25)*x*Sin[x])/E^(3*x) - ((3/10)*x^2*Sin[x])/E^(3*x)}
{E^(x/2)*x^2*Cos[x]^3, x, -31, (-(132/125))*E^(x/2)*Cos[x] + (18/25)*E^(x/2)*x*Cos[x] + (48/185)*E^(x/2)*x^2*Cos[x] + (2/37)*E^(x/2)*x^2*Cos[x]^3 - (428*E^(x/2)*Cos[3*x])/50653 + (70*E^(x/2)*x*Cos[3*x])/1369 - (24/125)*E^(x/2)*Sin[x] - (24/25)*E^(x/2)*x*Sin[x] + (96/185)*E^(x/2)*x^2*Sin[x] + (12/37)*E^(x/2)*x^2*Cos[x]^2*Sin[x] - (792*E^(x/2)*Sin[3*x])/50653 - (24*E^(x/2)*x*Sin[3*x])/1369}
{E^(2*x)*x^2*Sin[4*x], x, 11, (1/250)*E^(2*x)*Cos[4*x] + (2/25)*E^(2*x)*x*Cos[4*x] - (1/5)*E^(2*x)*x^2*Cos[4*x] - (11/500)*E^(2*x)*Sin[4*x] + (3/50)*E^(2*x)*x*Sin[4*x] + (1/10)*E^(2*x)*x^2*Sin[4*x]}


(* ::Subsection::Closed:: *)
(*Problems 50 (p. 359)*)


{E^(x/2)*x^2*Sin[x]^2*Cos[x], x, 24, (-(44/125))*E^(x/2)*Cos[x] + (6/25)*E^(x/2)*x*Cos[x] + (1/10)*E^(x/2)*x^2*Cos[x] + (428*E^(x/2)*Cos[3*x])/50653 - (70*E^(x/2)*x*Cos[3*x])/1369 - (1/74)*E^(x/2)*x^2*Cos[3*x] - (8/125)*E^(x/2)*Sin[x] - (8/25)*E^(x/2)*x*Sin[x] + (1/5)*E^(x/2)*x^2*Sin[x] + (792*E^(x/2)*Sin[3*x])/50653 + (24*E^(x/2)*x*Sin[3*x])/1369 - (3/37)*E^(x/2)*x^2*Sin[3*x]}


(* ::Subsection::Closed:: *)
(*Problems 51 - 55 (p. 361)*)


{Cosh[x], x, 1, Sinh[x]}
{Sinh[x], x, 1, Cosh[x]}
{Tanh[x], x, 1, Log[Cosh[x]]}
{Coth[x], x, 1, Log[Sinh[x]]}
{Sech[x], x, 1, ArcTan[Sinh[x]]}
{Csch[x], x, 1, -ArcTanh[Cosh[x]]}
{Cosh[x]^2, x, 2, x/2 + (1/2)*Cosh[x]*Sinh[x]}
{Sinh[x]^5, x, 2, Cosh[x] - (2*Cosh[x]^3)/3 + Cosh[x]^5/5}


(* ::Subsection::Closed:: *)
(*Problems 56 - 60 (p. 365)*)


{Tanh[x]^4, x, 3, x - Tanh[x] - Tanh[x]^3/3}
{Csch[x]^3, x, 2, (1/2)*ArcTanh[Cosh[x]] - (1/2)*Coth[x]*Csch[x]}
{1/Cosh[x]^5, x, 3, (3/8)*ArcTan[Sinh[x]] + (3/8)*Sech[x]*Tanh[x] + (1/4)*Sech[x]^3*Tanh[x]}
{Tanh[x]^5/Sech[x]^4, x, 4, -Cosh[x]^2 + Cosh[x]^4/4 + Log[Cosh[x]]}
{Tanh[x]^5*Sech[x]^(3/4), x, 3, (-(4/3))*Sech[x]^(3/4) + (8/11)*Sech[x]^(11/4) - (4/19)*Sech[x]^(19/4)}


(* ::Subsection::Closed:: *)
(*Problems 61 - 65 (p. 365-366)*)


{1/(a + b*Cosh[x]), x, 2, (2*ArcTanh[((a - b)*Tanh[x/2])/Sqrt[a^2 - b^2]])/Sqrt[a^2 - b^2], (2*ArcTanh[(Sqrt[a - b]*Tanh[x/2])/Sqrt[a + b]])/(Sqrt[a - b]*Sqrt[a + b])}
{1/(1 + Cosh[x])^2, x, 2, Sinh[x]/(3*(1 + Cosh[x])^2) + Sinh[x]/(3*(1 + Cosh[x]))}
{1/(a + b*Tanh[x]), x, 2, (a*x)/(a^2 - b^2) - (b*Log[a*Cosh[x] + b*Sinh[x]])/(a^2 - b^2)}
{1/(a^2 + b^2*Cosh[x]^2), x, 2, ArcTanh[(a*Tanh[x])/Sqrt[a^2 + b^2]]/(a*Sqrt[a^2 + b^2])}
{1/(a^2 - b^2*Cosh[x]^2), x, 2, ArcTanh[(a*Tanh[x])/Sqrt[a^2 - b^2]]/(a*Sqrt[a^2 - b^2])}
{1/(1 - Sinh[x]^4), x, 3, ArcTanh[Sqrt[2]*Tanh[x]]/(2*Sqrt[2]) + Tanh[x]/2}


(* ::Subsection::Closed:: *)
(*Problems 66 - 72 (p. 366-367)*)


{(Cosh[x]^3 - Sinh[x]^3)/(Cosh[x]^3 + Sinh[x]^3), x, 5, -((4*ArcTan[(1 - 2*Tanh[x])/Sqrt[3]])/(3*Sqrt[3])) - 1/(3*(1 + Tanh[x]))}
{Cosh[x]*Cosh[2*x]*Cosh[3*x], x, 5, x/4 + 1/8*Sinh[2*x] + 1/16*Sinh[4*x] + 1/24*Sinh[6*x]}
{Sinh[x]*Cosh[3*x/2]*Sinh[5*x/2], x, 5, -x/4 + 1/8*Sinh[2*x] - 1/12*Sinh[3*x] + 1/20*Sinh[5*x]}
{(Tanh[x] - Cosh[2*x])*(Cosh[x]/((Sinh[2*x] + Sinh[x]^2)*Sqrt[Sinh[2*x]])), x, 8, Sqrt[2]*ArcTan[Sech[x]*Sqrt[Cosh[x]*Sinh[x]]] + (1/6)*ArcTan[Sinh[x]/Sqrt[Sinh[2*x]]] - (1/3)*Sqrt[2]*ArcTanh[Sech[x]*Sqrt[Cosh[x]*Sinh[x]]] + Cosh[x]/Sqrt[Sinh[2*x]], Cosh[x]/Sqrt[Sinh[2*x]] + (2*ArcTan[Sqrt[Tanh[x]]]*Sinh[x])/(Sqrt[Sinh[2*x]]*Sqrt[Tanh[x]]) + (ArcTan[Sqrt[Tanh[x]]/Sqrt[2]]*Sinh[x])/(3*Sqrt[2]*Sqrt[Sinh[2*x]]*Sqrt[Tanh[x]]) - (2*ArcTanh[Sqrt[Tanh[x]]]*Sinh[x])/(3*Sqrt[Sinh[2*x]]*Sqrt[Tanh[x]])}
{Sinh[x]/(4*Cosh[x]^2 - 9)^(5/2), x, 3, -(Cosh[x]/(27*(-9 + 4*Cosh[x]^2)^(3/2))) + (2*Cosh[x])/(243*Sqrt[-9 + 4*Cosh[x]^2])}
{Sinh[x]^2*(Sinh[2*x]/(1 - Sinh[x]^2)^(3/2)), x, 5, 2/Sqrt[1 - Sinh[x]^2] + 2*Sqrt[1 - Sinh[x]^2]}
{Cosh[x]/Sqrt[Cosh[2*x]], x, 2, ArcSinh[Sqrt[2]*Sinh[x]]/Sqrt[2]}


(* ::Subsection::Closed:: *)
(*Problems 73 - 75 (p. 368)*)


{x*Tanh[x]^2, x, 3, x^2/2 + Log[Cosh[x]] - x*Tanh[x]}
{x*Coth[x]^2, x, 3, x^2/2 - x*Coth[x] + Log[Sinh[x]]}
{(x + Sinh[x] + Cosh[x])/(Cosh[x] - Sinh[x]), x, 13, -E^x + E^(2*x)/2 + E^x*x}
{(x + Sinh[x] + Cosh[x])/(1 + Cosh[x]), x, 8, x - (1 - x)*Tanh[x/2]}


(* ::Subsection::Closed:: *)
(*Problems 76 - 82 (p. 373)*)


{E^(2*x)/Sinh[x]^4, x, 3, (8*E^(6*x))/(3*(1 - E^(2*x))^3)}
{1/(E^(2*x)*Cosh[x]^4), x, 3, -(8/(3*(1 + E^(2*x))^3))}
{E^x/(Cosh[x] - Sinh[x]), x, 2, E^(2*x)/2}
{E^(m*x)/(Cosh[x] + Sinh[x]), x, 3, E^((m - 1)*x)/(m - 1), -(1/(E^((1 - m)*x)*(1 - m)))}
{E^x/(Cosh[x] + Sinh[x]), x, 2, x}
{E^x/(1 - Cosh[x]), x, 4, -(2/(1 - E^x)) - 2*Log[1 - E^x]}
{E^x*((1 + Sinh[x])/(1 + Cosh[x])), x, 3, E^x + 2/(1 + E^x)}
{E^x*((1 - Sinh[x])/(1 - Cosh[x])), x, 3, E^x - 2/(1 - E^x)}


(* ::Subsection::Closed:: *)
(*Problems 83 - 87 (p. 375)*)


{x^m*Log[x], x, 1, -(x^(1 + m)/(1 + m)^2) + (x^(1 + m)*Log[x])/(1 + m)}
{x^m*Log[x]^2, x, 2, (2*x^(1 + m))/(1 + m)^3 - (2*x^(1 + m)*Log[x])/(1 + m)^2 + (x^(1 + m)*Log[x]^2)/(1 + m)}
{Log[x]^2/x^(5/2), x, 2, -(16/(27*x^(3/2))) - (8*Log[x])/(9*x^(3/2)) - (2*Log[x]^2)/(3*x^(3/2))}
{(a + b*x)*Log[x], x, 2, (-a)*x - (b*x^2)/4 + a*x*Log[x] + (1/2)*b*x^2*Log[x]}
{(a + b*x)^3*Log[x], x, 4, (-a^3)*x - (3/4)*a^2*b*x^2 - (1/3)*a*b^2*x^3 - (b^3*x^4)/16 - (a^4*Log[x])/(4*b) + ((a + b*x)^4*Log[x])/(4*b)}


(* ::Subsection::Closed:: *)
(*Problems 88 - 89 (p. 375)*)


{3*Log[x]^3 - 8*Log[x]^2 - 1, x, 6, -35*x + 34*x*Log[x] - 17*x*Log[x]^2 + 3*x*Log[x]^3}
{(x^4 + 1)*(Log[x]^3 - 2*Log[x] + 1), x, 13, -3*x + (169*x^5)/625 + 4*x*Log[x] - (44/125)*x^5*Log[x] - 3*x*Log[x]^2 - (3/25)*x^5*Log[x]^2 + x*Log[x]^3 + (1/5)*x^5*Log[x]^3}


(* ::Subsection::Closed:: *)
(*Problems 90 - 92 (p. 376)*)


{1/(x^3*Log[x]^4), x, 5, (-(4/3))*ExpIntegralEi[-2*Log[x]] - 1/(3*x^2*Log[x]^3) + 1/(3*x^2*Log[x]^2) - 2/(3*x^2*Log[x])}
{Log[x]/(a + b*x), x, 2, (Log[x]*Log[1 + (b*x)/a])/b + PolyLog[2, -((b*x)/a)]/b}
{Log[x]/(a + b*x)^2, x, 2, (x*Log[x])/(a*(a + b*x)) - Log[a + b*x]/(a*b)}


(* ::Subsection::Closed:: *)
(*Problems 93 - 97 (p. 377)*)


{Log[x]^n/x, x, 2, Log[x]^(1 + n)/(1 + n)}
{(a + b*Log[x])^n/x, x, 2, (a + b*Log[x])^(1 + n)/(b*(1 + n))}
{1/(x*(a + b*Log[x])), x, 2, Log[a + b*Log[x]]/b}
{1/(x*(a + b*Log[x])^n), x, 2, (a + b*Log[x])^(1 - n)/(b*(1 - n))}
{1/(x*Sqrt[Log[x]^2 + a^2]), x, 3, ArcTanh[Log[x]/Sqrt[Log[x]^2 + a^2]]}
{1/(x*Sqrt[Log[x]^2 - a^2]), x, 3, ArcTanh[Log[x]/Sqrt[Log[x]^2 - a^2]]}
{1/(x*Sqrt[a^2 - Log[x]^2]), x, 3, ArcTan[Log[x]/Sqrt[a^2 - Log[x]^2]]}
{1/(x*Log[x]*Sqrt[a^2 + Log[x]^2]), x, 4, -(ArcTanh[Sqrt[a^2 + Log[x]^2]/a]/a)}
{1/(x*Log[x]*Sqrt[a^2 - Log[x]^2]), x, 4, -(ArcTanh[Sqrt[a^2 - Log[x]^2]/a]/a)}
{1/(x*Log[x]*Sqrt[Log[x]^2 - a^2]), x, 4, ArcTan[Sqrt[-a^2 + Log[x]^2]/a]/a}
{Log[Log[x]]^1/x, x, 1, -Log[x] + Log[x]*Log[Log[x]]}
{Log[Log[x]]^2/x, x, 3, 2*Log[x] - 2*Log[x]*Log[Log[x]] + Log[x]*Log[Log[x]]^2}
{Log[Log[x]]^3/x, x, 4, -6*Log[x] + 6*Log[x]*Log[Log[x]] - 3*Log[x]*Log[Log[x]]^2 + Log[x]*Log[Log[x]]^3}
{Log[Log[x]]^4/x, x, 5, 24*Log[x] - 24*Log[x]*Log[Log[x]] + 12*Log[x]*Log[Log[x]]^2 - 4*Log[x]*Log[Log[x]]^3 + Log[x]*Log[Log[x]]^4}
{Log[Log[x]]^n/x, x, 3, (Gamma[1 + n, -Log[Log[x]]]*Log[Log[x]]^n)/(-Log[Log[x]])^n}


(* ::Subsection::Closed:: *)
(*Problems 98 - 103 (p. 377-378)*)


{Cot[x]/Log[Sin[x]], x, 3, Log[Log[Sin[x]]]}
{(E^Log[Cos[x]] + E^(-Log[Cos[x]]))*Tan[x], x, 3, -Cos[x] + Sec[x]}
{Sinh[x]*Log[Cosh[x]], x, 2, -Cosh[x] + Cosh[x]*Log[Cosh[x]]}
{Tanh[x]*Log[Cosh[x]], x, 2, (1/2)*Log[Cosh[x]]^2}
{Log[x - Sqrt[1 + x^2]], x, 2, Sqrt[1 + x^2] + x*Log[x - Sqrt[1 + x^2]]}
{Log[x - 1]/x^3, x, 3, 1/(2*x) + (1/2)*Log[1 - x] - Log[-1 + x]/(2*x^2) - Log[x]/2}


(* ::Subsection::Closed:: *)
(*Problems 104 - 109 (p. 378)*)


{(E^x - E^(-x))*Log[E^(2*x) + 1], x, 8, -2*E^x + Log[1 + E^(2*x)]/E^x + E^x*Log[1 + E^(2*x)]}
{E^(3*x/2)*Log[E^x - 1], x, 6, -((4*E^(x/2))/3) - (4/9)*E^((3*x)/2) + (4/3)*ArcTanh[E^(x/2)] + (2/3)*E^((3*x)/2)*Log[-1 + E^x]}
{Cos[x]^3*Log[Sin[x]], x, 4, -Sin[x] + Log[Sin[x]]*Sin[x] + Sin[x]^3/9 - (1/3)*Log[Sin[x]]*Sin[x]^3}
{Log[Tan[x]]/Cos[x]^4, x, 4, -Tan[x] + Log[Tan[x]]*Tan[x] - Tan[x]^3/9 + (1/3)*Log[Tan[x]]*Tan[x]^3}
{Log[Cos[x/2]]/(1 + Cos[x]), x, 4, -(x/2) + (Log[Cos[x/2]]*Sin[x])/(1 + Cos[x]) + Tan[x/2]}
{Cos[x]*Log[Sin[x]]/(1 + Cos[x])^2, x, 6, -((2*x)/3) - Sin[x]/(9*(1 + Cos[x])^2) + (8*Sin[x])/(9*(1 + Cos[x])) - (Log[Sin[x]]*Sin[x])/(3*(1 + Cos[x])^2) + (2*Log[Sin[x]]*Sin[x])/(3*(1 + Cos[x]))}


(* ::Section::Closed:: *)
(*Chapter 9 Integration Problems*)


(* ::Subsection::Closed:: *)
(*Problems 1 - 6 (p. 391-392) *)


{ArcCos[x]^2/x^5, x, 5, -(1/(12*x^2)) + (Sqrt[1 - x^2]*ArcCos[x])/(6*x^3) + (Sqrt[1 - x^2]*ArcCos[x])/(3*x) - ArcCos[x]^2/(4*x^4) + Log[x]/3}
{x^2*ArcSin[x]^2, x, 5, -((4*x)/9) - (2*x^3)/27 + (4/9)*Sqrt[1 - x^2]*ArcSin[x] + (2/9)*x^2*Sqrt[1 - x^2]*ArcSin[x] + (1/3)*x^3*ArcSin[x]^2}
{ArcTan[x]^2*x^3, x, 10, x^2/12 + (1/2)*x*ArcTan[x] - (1/6)*x^3*ArcTan[x] - ArcTan[x]^2/4 + (1/4)*x^4*ArcTan[x]^2 - (1/3)*Log[1 + x^2]}
{ArcTan[x]^2/x^5, x, 13, -(1/(12*x^2)) - ArcTan[x]/(6*x^3) + ArcTan[x]/(2*x) + ArcTan[x]^2/4 - ArcTan[x]^2/(4*x^4) - (2*Log[x])/3 + (1/3)*Log[1 + x^2]}
{ArcCsc[x]^2*x^3, x, 5, x^2/12 + (1/3)*Sqrt[1 - 1/x^2]*x*ArcCsc[x] + (1/6)*Sqrt[1 - 1/x^2]*x^3*ArcCsc[x] + (1/4)*x^4*ArcCsc[x]^2 + Log[x]/3}
{ArcSec[x]^4/x^5, x, 10, -(3/(128*x^4)) - 45/(128*x^2) - (3*Sqrt[1 - 1/x^2]*ArcSec[x])/(32*x^3) - (45*Sqrt[1 - 1/x^2]*ArcSec[x])/(64*x) - (45*ArcSec[x]^2)/128 + (3*ArcSec[x]^2)/(16*x^4) + (9*ArcSec[x]^2)/(16*x^2) + (Sqrt[1 - 1/x^2]*ArcSec[x]^3)/(4*x^3) + (3*Sqrt[1 - 1/x^2]*ArcSec[x]^3)/(8*x) + (3*ArcSec[x]^4)/32 - ArcSec[x]^4/(4*x^4)}


(* ::Subsection::Closed:: *)
(*Problems 7 - 18 (p. 397-398) *)


{ArcSin[x]*Sqrt[1 - x^2], x, 3, -(x^2/4) + (1/2)*x*Sqrt[1 - x^2]*ArcSin[x] + ArcSin[x]^2/4}
{ArcCos[x]*Sqrt[1 - x^2], x, 3, x^2/4 + (1/2)*x*Sqrt[1 - x^2]*ArcCos[x] - ArcCos[x]^2/4}
{ArcCos[x]*x*Sqrt[1 - x^2], x, 2, -(x/3) + x^3/9 - (1/3)*(1 - x^2)^(3/2)*ArcCos[x]}
{ArcSin[x]*(1 - x^2)^(3/2), x, 6, -((5*x^2)/16) + x^4/16 + (3/8)*x*Sqrt[1 - x^2]*ArcSin[x] + (1/4)*x*(1 - x^2)^(3/2)*ArcSin[x] + (3*ArcSin[x]^2)/16}
{ArcSin[x]*x*(1 - x^2)^(3/2), x, 3, x/5 - (2*x^3)/15 + x^5/25 - (1/5)*(1 - x^2)^(5/2)*ArcSin[x]}
{ArcCos[x]*x^3*(1 - x^2)^(3/2), x, 4, (-(1/35))*(2*x) - x^3/105 + (8*x^5)/175 - x^7/49 - (1/5)*(1 - x^2)^(5/2)*ArcCos[x] + (1/7)*(1 - x^2)^(7/2)*ArcCos[x]}
{(ArcCos[x]*(1 - x^2)^(3/2))/x, x, 10, (4*x)/3 - x^3/9 + Sqrt[1 - x^2]*ArcCos[x] + (1/3)*(1 - x^2)^(3/2)*ArcCos[x] + 2*I*ArcCos[x]*ArcTan[E^(I*ArcCos[x])] - I*PolyLog[2, (-I)*E^(I*ArcCos[x])] + I*PolyLog[2, I*E^(I*ArcCos[x])]}
{(ArcSin[x]*(1 - x^2)^(3/2))/x^6, x, 4, -(1/(20*x^4)) + 1/(5*x^2) - ((1 - x^2)^(5/2)*ArcSin[x])/(5*x^5) + Log[x]/5}
{(ArcSin[x]*x^2)/Sqrt[1 - x^2], x, 3, x^2/4 - (1/2)*x*Sqrt[1 - x^2]*ArcSin[x] + ArcSin[x]^2/4}
{(ArcSin[x]*x^4)/Sqrt[1 - x^2], x, 5, (3*x^2)/16 + x^4/16 - (3/8)*x*Sqrt[1 - x^2]*ArcSin[x] - (1/4)*x^3*Sqrt[1 - x^2]*ArcSin[x] + (3*ArcSin[x]^2)/16}
{(ArcSin[x]*x)/(1 - x^2)^(3/2), x, 2, ArcSin[x]/Sqrt[1 - x^2] - ArcTanh[x]}
{(ArcCos[x]*x)/(1 - x^2)^(3/2), x, 2, ArcCos[x]/Sqrt[1 - x^2] + ArcTanh[x]}
{ArcSin[x]/(1 - x^2)^(5/2), x, 4, -(1/(6*(1 - x^2))) + (x*ArcSin[x])/(3*(1 - x^2)^(3/2)) + (2*x*ArcSin[x])/(3*Sqrt[1 - x^2]) + (1/3)*Log[1 - x^2]}
{(ArcSin[x]*x^3)/(1 - x^2)^(3/2), x, 3, -x + ArcSin[x]/Sqrt[1 - x^2] + Sqrt[1 - x^2]*ArcSin[x] - ArcTanh[x]}


(* ::Subsection::Closed:: *)
(*Problems 19 - 22 (p. 401)*)


{ArcSin[x]/(x*(1 - x^2)^(3/2)), x, 8, ArcSin[x]/Sqrt[1 - x^2] - 2*ArcSin[x]*ArcTanh[E^(I*ArcSin[x])] - ArcTanh[x] + I*PolyLog[2, -E^(I*ArcSin[x])] - I*PolyLog[2, E^(I*ArcSin[x])]}
{ArcCos[x]/(x^4*Sqrt[1 - x^2]), x, 4, 1/(6*x^2) - (Sqrt[1 - x^2]*ArcCos[x])/(3*x^3) - (2*Sqrt[1 - x^2]*ArcCos[x])/(3*x) - (2*Log[x])/3}
{ArcCos[x]^2*x*Sqrt[1 - x^2], x, 5, (4*Sqrt[1 - x^2])/9 + (2/27)*(1 - x^2)^(3/2) - (2/3)*x*ArcCos[x] + (2/9)*x^3*ArcCos[x] - (1/3)*(1 - x^2)^(3/2)*ArcCos[x]^2}
{(ArcSin[x]^3*x^2)/Sqrt[1 - x^2], x, 6, -((3*x^2)/8) + (3/4)*x*Sqrt[1 - x^2]*ArcSin[x] - (3*ArcSin[x]^2)/8 + (3/4)*x^2*ArcSin[x]^2 - (1/2)*x*Sqrt[1 - x^2]*ArcSin[x]^3 + ArcSin[x]^4/8}


(* ::Subsection::Closed:: *)
(*Problems 23 - 26 (p. 404-405)*)


{(ArcTan[x]*x)/(1 + x^2)^2, x, 3, x/(4*(1 + x^2)) + ArcTan[x]/4 - ArcTan[x]/(2*(1 + x^2))}
{(ArcTan[x]*x)/(1 + x^2)^3, x, 4, x/(16*(1 + x^2)^2) + (3*x)/(32*(1 + x^2)) + (3*ArcTan[x])/32 - ArcTan[x]/(4*(1 + x^2)^2)}
{(ArcTan[x]*x^2)/(1 + x^2), x, 4, x*ArcTan[x] - ArcTan[x]^2/2 - (1/2)*Log[1 + x^2]}
{(ArcTan[x]*x^3)/(1 + x^2), x, 8, -(x/2) + ArcTan[x]/2 + (1/2)*x^2*ArcTan[x] + (1/2)*I*ArcTan[x]^2 + ArcTan[x]*Log[2/(1 + I*x)] + (1/2)*I*PolyLog[2, 1 - 2/(1 + I*x)]}


(* ::Subsection::Closed:: *)
(*Problems 27 - 32 (p. 407-408)*)


{(ArcTan[x]*x^2)/(1 + x^2)^2, x, 2, -(1/(4*(1 + x^2))) - (x*ArcTan[x])/(2*(1 + x^2)) + ArcTan[x]^2/4}
{(ArcTan[x]*x^3)/(1 + x^2)^2, x, 8, -(x/(4*(1 + x^2))) - ArcTan[x]/4 + ArcTan[x]/(2*(1 + x^2)) - (1/2)*I*ArcTan[x]^2 - ArcTan[x]*Log[2/(1 + I*x)] - (1/2)*I*PolyLog[2, 1 - 2/(1 + I*x)]}
{(ArcTan[x]*x^5)/(1 + x^2)^2, x, 17, -(x/2) + x/(4*(1 + x^2)) + (3*ArcTan[x])/4 + (1/2)*x^2*ArcTan[x] - ArcTan[x]/(2*(1 + x^2)) + I*ArcTan[x]^2 + 2*ArcTan[x]*Log[2/(1 + I*x)] + I*PolyLog[2, 1 - 2/(1 + I*x)]}
{(ArcTan[x]*(1 + x^2))/x^2, x, 8, -(ArcTan[x]/x) + x*ArcTan[x] + Log[x] - Log[1 + x^2]}
{(ArcTan[x]*(1 + x^2))/x^5, x, 3, -(1/(12*x^3)) - 1/(4*x) - ((1 + x^2)^2*ArcTan[x])/(4*x^4)}
{(ArcTan[x]*(1 + x^2)^2)/x^5, x, 12, -(1/(12*x^3)) - 3/(4*x) - (3*ArcTan[x])/4 - ArcTan[x]/(4*x^4) - ArcTan[x]/x^2 + (1/2)*I*PolyLog[2, (-I)*x] - (1/2)*I*PolyLog[2, I*x]}


(* ::Subsection::Closed:: *)
(*Problems 33 - 36 (p. 409)*)


{ArcTan[x]/(x^2*(1 + x^2)), x, 7, -(ArcTan[x]/x) - ArcTan[x]^2/2 + Log[x] - (1/2)*Log[1 + x^2]}
{ArcTan[x]^2/x^3, x, 8, -(ArcTan[x]/x) - ArcTan[x]^2/2 - ArcTan[x]^2/(2*x^2) + Log[x] - (1/2)*Log[1 + x^2]}
{(ArcTan[x]^2*(1 + x^2))/x^5, x, 11, -(1/(12*x^2)) - ArcTan[x]/(6*x^3) - ArcTan[x]/(2*x) - ((1 + x^2)^2*ArcTan[x]^2)/(4*x^4) + Log[x]/3 - (1/6)*Log[1 + x^2]}
{(ArcTan[x]^2*x^3)/(1 + x^2)^3, x, 4, -(1/(32*(1 + x^2)^2)) + 5/(32*(1 + x^2)) + (x^3*ArcTan[x])/(8*(1 + x^2)^2) + (3*x*ArcTan[x])/(16*(1 + x^2)) - (3*ArcTan[x]^2)/32 + (x^4*ArcTan[x]^2)/(4*(1 + x^2)^2), -(x^4/(32*(1 + x^2)^2)) + 3/(32*(1 + x^2)) + (x^3*ArcTan[x])/(8*(1 + x^2)^2) + (3*x*ArcTan[x])/(16*(1 + x^2)) - (3*ArcTan[x]^2)/32 + (x^4*ArcTan[x]^2)/(4*(1 + x^2)^2)}


(* ::Subsection::Closed:: *)
(*Problems 37 - 43 (p. 412-414)*)


{(ArcSec[x]*Sqrt[x^2 - 1])/x^2, x, 9, -(Sqrt[x^2]/x^2) - (Sqrt[-1 + x^2]*ArcSec[x])/x - (2*I*Sqrt[x^2]*ArcSec[x]*ArcTan[E^(I*ArcSec[x])])/x + (I*Sqrt[x^2]*PolyLog[2, (-I)*E^(I*ArcSec[x])])/x - (I*Sqrt[x^2]*PolyLog[2, I*E^(I*ArcSec[x])])/x, -(Sqrt[x^2]/x^2) - (Sqrt[1 - 1/x^2]*Sqrt[x^2]*ArcSec[x])/x - (2*I*Sqrt[x^2]*ArcSec[x]*ArcTan[E^(I*ArcSec[x])])/x + (I*Sqrt[x^2]*PolyLog[2, (-I)*E^(I*ArcSec[x])])/x - (I*Sqrt[x^2]*PolyLog[2, I*E^(I*ArcSec[x])])/x}
{(ArcCsc[x]*(x^2 - 1)^(5/2))/x^3, x, 11, (3 + 2*x^4)/(12*x*Sqrt[x^2]) - (5*(x^2 - 1)^(3/2)*ArcCsc[x])/(3*x^2) - (5*Sqrt[x^2 - 1]*ArcCsc[x])/(2*x^2) + ((x^2 - 1)^(5/2)*ArcCsc[x])/(3*x^2) - (5*x*ArcCsc[x]^2)/(4*Sqrt[x^2]) - (7*x*Log[x])/(3*Sqrt[x^2]), Sqrt[x^2]/(4*x^3) + (x*Sqrt[x^2])/6 - (5/3)*(1 - 1/x^2)^(3/2)*Sqrt[x^2]*ArcCsc[x] - (5*Sqrt[1 - 1/x^2]*Sqrt[x^2]*ArcCsc[x])/(2*x^2) + (1/3)*(1 - 1/x^2)^(5/2)*(x^2)^(3/2)*ArcCsc[x] - (5*Sqrt[x^2]*ArcCsc[x]^2)/(4*x) - (7*Sqrt[x^2]*Log[x])/(3*x)}
{(ArcSec[x]*Sqrt[x^2 - 1])/x^4, x, 4, 1/(3*Sqrt[x^2]) - 1/(9*x^2)/Sqrt[x^2] + ((x^2 - 1)^(3/2)*ArcSec[x])/(3*x^3)}
{ArcSec[x]/(x^2 - 1)^(5/2), x, 4, Sqrt[x^2]/(6*(1 - x^2)) - (x*ArcSec[x])/(3*(x^2 - 1)^(3/2)) + (2*x*ArcSec[x])/(3*Sqrt[x^2 - 1]) + (5*ArcCoth[Sqrt[x^2]])/6, Sqrt[x^2]/(6*(1 - x^2)) - (x*ArcSec[x])/(3*(-1 + x^2)^(3/2)) + (2*x*ArcSec[x])/(3*Sqrt[-1 + x^2]) + (5*x*ArcTanh[x])/(6*Sqrt[x^2])}
{(ArcSec[x]*x^2)/(x^2 - 1)^(5/2), x, 4, Sqrt[x^2]/(6*(1 - x^2)) - (x^3*ArcSec[x])/(3*(x^2 - 1)^(3/2)) - ArcCoth[Sqrt[x^2]]/6, Sqrt[x^2]/(6*(1 - x^2)) - (x^3*ArcSec[x])/(3*(-1 + x^2)^(3/2)) - (x*ArcTanh[x])/(6*Sqrt[x^2])}
{(ArcSec[x]*x^3)/(x^2 - 1)^(5/2), x, 5, x/(6*Sqrt[x^2]*(1 - x^2)) - ArcSec[x]/(3*(x^2 - 1)^(3/2)) - ArcSec[x]/Sqrt[x^2 - 1] - (2*x*Log[x])/(3*Sqrt[x^2]) + (x*Log[x^2 - 1])/(3*Sqrt[x^2]), x/(6*Sqrt[x^2]*(1 - x^2)) - ArcSec[x]/(3*(-1 + x^2)^(3/2)) - ArcSec[x]/Sqrt[-1 + x^2] - (2*x*Log[x])/(3*Sqrt[x^2]) + (x*Log[1 - x^2])/(3*Sqrt[x^2])}
{(ArcSec[x]*x^6)/(x^2 - 1)^(5/2), x, 16, (Sqrt[x^2]*(2 - 3*x^2))/(6*(-1 + x^2)) - (13/6)*ArcCoth[Sqrt[x^2]] - (5*x^3*ArcSec[x])/(6*(-1 + x^2)^(3/2)) + (x^5*ArcSec[x])/(2*(-1 + x^2)^(3/2)) - (5*x*ArcSec[x])/(2*Sqrt[-1 + x^2]) - (5*I*Sqrt[x^2]*ArcSec[x]*ArcTan[E^(I*ArcSec[x])])/x + (5*I*Sqrt[x^2]*PolyLog[2, (-I)*E^(I*ArcSec[x])])/(2*x) - (5*I*Sqrt[x^2]*PolyLog[2, I*E^(I*ArcSec[x])])/(2*x), -((3*Sqrt[x^2])/4) + Sqrt[x^2]/(4*(1 - 1/x^2)) - (5*Sqrt[x^2])/(12*(1 - 1/x^2)*x^2) - (13*Sqrt[x^2]*ArcCoth[x])/(6*x) - (5*Sqrt[x^2]*ArcSec[x])/(6*(1 - 1/x^2)^(3/2)*x) - (5*Sqrt[x^2]*ArcSec[x])/(2*Sqrt[1 - 1/x^2]*x) + (x*Sqrt[x^2]*ArcSec[x])/(2*(1 - 1/x^2)^(3/2)) - (5*I*Sqrt[x^2]*ArcSec[x]*ArcTan[E^(I*ArcSec[x])])/x + (5*I*Sqrt[x^2]*PolyLog[2, (-I)*E^(I*ArcSec[x])])/(2*x) - (5*I*Sqrt[x^2]*PolyLog[2, I*E^(I*ArcSec[x])])/(2*x)}


(* ::Subsection::Closed:: *)
(*Problems 44 - 48 (p. 416-417)*)


{ArcSec[x]/(x^2*Sqrt[x^2 - 1]), x, 2, 1/Sqrt[x^2] + (Sqrt[x^2 - 1]*ArcSec[x])/x}
{ArcCsc[x]/(x^2*(x^2 - 1)^(5/2)), x, 5, -(1/Sqrt[x^2]) + Sqrt[x^2]/(6*(x^2 - 1)) + ((3 - 12*x^2 + 8*x^4)*ArcCsc[x])/(3*x*(x^2 - 1)^(3/2)) - (11*ArcCoth[Sqrt[x^2]])/6, -(1/Sqrt[x^2]) - Sqrt[x^2]/(6*(1 - x^2)) + ArcCsc[x]/(x*(-1 + x^2)^(3/2)) - (4*x*ArcCsc[x])/(3*(-1 + x^2)^(3/2)) + (8*x*ArcCsc[x])/(3*Sqrt[-1 + x^2]) - (11*x*ArcTanh[x])/(6*Sqrt[x^2])}
{ArcCsc[x]^4/(x^2*Sqrt[x^2 - 1]), x, 6, (24*Sqrt[x^2 - 1])/x + (24*ArcCsc[x])/Sqrt[x^2] - (12*Sqrt[x^2 - 1]*ArcCsc[x]^2)/x - (4*ArcCsc[x]^3)/Sqrt[x^2] + (Sqrt[x^2 - 1]*ArcCsc[x]^4)/x, (24*Sqrt[1 - 1/x^2]*Sqrt[x^2])/x + (24*Sqrt[x^2]*ArcCsc[x])/x^2 - (12*Sqrt[1 - 1/x^2]*Sqrt[x^2]*ArcCsc[x]^2)/x - (4*Sqrt[x^2]*ArcCsc[x]^3)/x^2 + (Sqrt[1 - 1/x^2]*Sqrt[x^2]*ArcCsc[x]^4)/x}
{(ArcSec[x]^2*(x^2 - 1)^(3/2))/x^5, x, 11, (Sqrt[x^2 - 1]*(17*x^2 - 2))/(64*x^4) - (3*ArcSec[x])/(8*x*Sqrt[x^2]) + (9*x*ArcSec[x])/(64*Sqrt[x^2]) + ((x^2 - 1)^2*ArcSec[x])/(8*x^3*Sqrt[x^2]) - (3*Sqrt[x^2 - 1]*ArcSec[x]^2)/(8*x^2) - ((x^2 - 1)^(3/2)*ArcSec[x]^2)/(4*x^4) + (x*ArcSec[x]^3)/(8*Sqrt[x^2]), (15*Sqrt[1 - 1/x^2]*Sqrt[x^2])/(64*x^2) + ((1 - 1/x^2)^(3/2)*Sqrt[x^2])/(32*x^2) - (9*Sqrt[x^2]*ArcCsc[x])/(64*x) - (3*Sqrt[x^2]*ArcSec[x])/(8*x^3) + ((1 - 1/x^2)^2*Sqrt[x^2]*ArcSec[x])/(8*x) - (3*Sqrt[1 - 1/x^2]*Sqrt[x^2]*ArcSec[x]^2)/(8*x^2) - ((1 - 1/x^2)^(3/2)*Sqrt[x^2]*ArcSec[x]^2)/(4*x^2) + (Sqrt[x^2]*ArcSec[x]^3)/(8*x)}
{(ArcSec[x]^3*Sqrt[x^2 - 1])/x^4, x, 8, (2*(1 - 21*x^2))/(27*x^2*Sqrt[x^2]) - (4*Sqrt[x^2 - 1]*ArcSec[x])/(3*x) - (2*(x^2 - 1)^(3/2)*ArcSec[x])/(9*x^3) + (2*ArcSec[x]^2)/(3*Sqrt[x^2]) + ((x^2 - 1)*ArcSec[x]^2)/(3*x^2*Sqrt[x^2]) + ((x^2 - 1)^(3/2)*ArcSec[x]^3)/(3*x^3), (2*Sqrt[x^2])/(27*x^4) - (14*Sqrt[x^2])/(9*x^2) - (4*Sqrt[1 - 1/x^2]*Sqrt[x^2]*ArcSec[x])/(3*x) - (2*(1 - 1/x^2)^(3/2)*Sqrt[x^2]*ArcSec[x])/(9*x) + (2*Sqrt[x^2]*ArcSec[x]^2)/(3*x^2) + ((1 - 1/x^2)*Sqrt[x^2]*ArcSec[x]^2)/(3*x^2) + ((1 - 1/x^2)^(3/2)*Sqrt[x^2]*ArcSec[x]^3)/(3*x)}


(* ::Subsection::Closed:: *)
(*Problems 49 - 56 (p. 422)*)


{ArcSin[Sqrt[(x - a)/(x + a)]], x, -8, -Sqrt[2]*a*Sqrt[(x - a)/(x + a)]/Sqrt[a/(x + a)] + (x + a)*ArcSin[Sqrt[(x - a)/(x + a)]]}
{ArcTan[Sqrt[(x - a)/(x + a)]], x, 4, x*ArcTan[Sqrt[-((a - x)/(a + x))]] - a*ArcTanh[Sqrt[-((a - x)/(a + x))]]}
{ArcTan[x]/(1 + x)^3, x, 5, -(1/(4*(1 + x))) - ArcTan[x]/(2*(1 + x)^2) + (1/4)*Log[1 + x] - (1/8)*Log[1 + x^2]}
{ArcTan[x - a]/(x + a), x, 5, ArcTan[a - x]*Log[2/(1 - I*(a - x))] - ArcTan[a - x]*Log[-((2*(a + x))/((I - 2*a)*(1 - I*(a - x))))] - (1/2)*I*PolyLog[2, 1 - 2/(1 - I*(a - x))] + (1/2)*I*PolyLog[2, 1 + (2*(a + x))/((I - 2*a)*(1 - I*(a - x)))]}
{ArcSin[Sqrt[1 - x^2]]/Sqrt[1 - x^2], x, 2, -Sqrt[x^2]*ArcSin[Sqrt[1 - x^2]]^2/(2*x)}
{ArcTan[Sqrt[1 + x^2]]*x/Sqrt[1 + x^2], x, 2, Sqrt[1 + x^2]*ArcTan[Sqrt[1 + x^2]] - (1/2)*Log[2 + x^2]}
{ArcSin[x]/(1 - x)^(5/2), x, 5, -(Sqrt[1 + x]/(3*(1 - x))) + (2*ArcSin[x])/(3*(1 - x)^(3/2)) - (1/(3*Sqrt[2]))*ArcTanh[Sqrt[1 + x]/Sqrt[2]]}
{ArcCsc[x]*(x - 1)^(5/2), x, 7, (4*x*(83 - 19*x + 3*x^2)*Sqrt[x^2 - 1])/(105*Sqrt[x - 1]*Sqrt[x^2]) + (2/7)*(x - 1)^(7/2)*ArcCsc[x] + ((4*x)/(7*Sqrt[x^2]))*ArcTanh[Sqrt[x^2 - 1]/Sqrt[x - 1]], (4*Sqrt[-1 + x]*(1 + x))/(Sqrt[1 - 1/x^2]*x) - (20*Sqrt[-1 + x]*(1 + x)^2)/(21*Sqrt[1 - 1/x^2]*x) + (4*Sqrt[-1 + x]*(1 + x)^3)/(35*Sqrt[1 - 1/x^2]*x) + (2/7)*(-1 + x)^(7/2)*ArcCsc[x] + (4*Sqrt[-1 + x]*Sqrt[1 + x]*ArcTanh[Sqrt[1 + x]])/(7*Sqrt[1 - 1/x^2]*x)}


(* ::Subsection::Closed:: *)
(*Problems 57 - 59 (p. 427)*)


{ArcSin[Sinh[x]]*Sech[x]^4, x, 5, (-2/3)*ArcSin[Cosh[x]/Sqrt[2]] + (1/6)*Sqrt[1 - Sinh[x]^2]*Sech[x] + ArcSin[Sinh[x]]*Tanh[x] - (1/3)*ArcSin[Sinh[x]]*Tanh[x]^3, (-(2/3))*ArcSin[Cosh[x]/Sqrt[2]] + (1/6)*Sqrt[2 - Cosh[x]^2]*Sech[x] + ArcSin[Sinh[x]]*Tanh[x] - (1/3)*ArcSin[Sinh[x]]*Tanh[x]^3}
{ArcCot[Cosh[x]]*Cosh[x]/Sinh[x]^4, x, 6, ArcTanh[Tanh[x]/Sqrt[2]]/(6*Sqrt[2]) + Coth[x]/6 - (1/3)*ArcCot[Cosh[x]]*Csch[x]^3}
{ArcSin[Tanh[x]]*E^x, x, 5, E^x*ArcSin[Tanh[x]] - Cosh[x]*Log[1 + E^(2*x)]*Sqrt[Sech[x]^2]}
